/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.expression;

import apache.harmony.math.BigInteger;
import apache.harmony.math.Primality;
import apache.harmony.math.Rational;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.matheclipse.core.expression.ExprImpl;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.expression.FractionSym;
import org.matheclipse.core.expression.Num;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.IInteger;
import org.matheclipse.core.interfaces.ISignedNumber;
import org.matheclipse.core.interfaces.ISymbol;
import org.matheclipse.core.visit.IVisitor;
import org.matheclipse.core.visit.IVisitorBoolean;
import org.matheclipse.core.visit.IVisitorInt;

public class IntegerSym
extends ExprImpl
implements IInteger {
    private static final long serialVersionUID = 6389228668633533063L;
    BigInteger fInteger = null;

    protected static IntegerSym newInstance(BigInteger value) {
        IntegerSym z = new IntegerSym();
        z.fInteger = value;
        return z;
    }

    public static IntegerSym valueOf(long value) {
        IntegerSym z = new IntegerSym();
        z.fInteger = BigInteger.valueOf(value);
        return z;
    }

    public static IntegerSym valueOf(String integerString, int radix) {
        IntegerSym z = new IntegerSym();
        z.fInteger = BigInteger.valueOf(integerString, radix);
        return z;
    }

    private IntegerSym() {
    }

    @Override
    public boolean equalsInt(int i) {
        return this.fInteger.equals(BigInteger.valueOf(i));
    }

    @Override
    public int hierarchy() {
        return 8;
    }

    @Override
    public IInteger add(IInteger val) {
        return IntegerSym.newInstance(this.fInteger.plus(val.getBigNumerator()));
    }

    @Override
    public IInteger multiply(IInteger val) {
        return IntegerSym.newInstance(this.fInteger.times(val.getBigNumerator()));
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof IntegerSym) {
            return this.fInteger.equals(((IntegerSym)obj).fInteger);
        }
        return false;
    }

    public static IntegerSym valueOf(BigInteger bigInteger) {
        return IntegerSym.newInstance(BigInteger.valueOf(bigInteger));
    }

    @Override
    public IntegerSym eabs() {
        return IntegerSym.newInstance(this.fInteger.abs());
    }

    public IntegerSym add(IntegerSym that) {
        return IntegerSym.newInstance(this.fInteger.plus(that.fInteger));
    }

    public int bitLength() {
        return this.fInteger.bitLength();
    }

    @Override
    public BigInteger divide(int i) {
        return this.fInteger.divide(i);
    }

    @Override
    public BigInteger divide(BigInteger that) {
        return this.fInteger.divide(that);
    }

    public IntegerSym quotient(IntegerSym that) {
        return IntegerSym.newInstance(this.fInteger.divide(that.fInteger));
    }

    @Override
    public double doubleValue() {
        return this.fInteger.doubleValue();
    }

    @Override
    public IntegerSym gcd(IntegerSym that) {
        return IntegerSym.newInstance(this.fInteger.gcd(that.fInteger));
    }

    @Override
    public IInteger gcd(IInteger that) {
        return IntegerSym.newInstance(this.fInteger.gcd(((IntegerSym)that).fInteger));
    }

    public IntegerSym lcm(IntegerSym that) {
        BigInteger gcd = this.fInteger.gcd(that.fInteger);
        BigInteger lcm = this.fInteger.multiply(that.fInteger).divide(gcd);
        return IntegerSym.newInstance(lcm);
    }

    @Override
    public IInteger lcm(IInteger that) {
        return this.lcm((IntegerSym)that);
    }

    @Override
    public int hashCode() {
        return this.fInteger.hashCode();
    }

    public boolean isLargerThan(BigInteger that) {
        return this.fInteger.isLargerThan(that);
    }

    @Override
    public boolean isNegative() {
        return this.fInteger.isNegative();
    }

    @Override
    public boolean isPositive() {
        return this.fInteger.isPositive();
    }

    @Override
    public boolean isZero() {
        return this.fInteger.isZero();
    }

    @Override
    public boolean isOne() {
        return this.fInteger.isOne();
    }

    @Override
    public int intValue() {
        return (int)this.fInteger.longValue();
    }

    @Override
    public long longValue() {
        return this.fInteger.longValue();
    }

    public IntegerSym mod(IntegerSym that) {
        return IntegerSym.newInstance(this.fInteger.mod(that.fInteger));
    }

    public IntegerSym copy() {
        IntegerSym z = new IntegerSym();
        z.fInteger = this.fInteger.copy();
        return z;
    }

    public IntegerSym copyNew() {
        IntegerSym i = new IntegerSym();
        i.fInteger = this.fInteger.copyNew();
        return i;
    }

    @Override
    public IntegerSym multiply(IntegerSym that) {
        return IntegerSym.newInstance(this.fInteger.times(that.fInteger));
    }

    @Override
    public BigInteger multiply(long l) {
        return this.fInteger.times(l);
    }

    @Override
    public ISignedNumber negate() {
        return IntegerSym.newInstance(this.fInteger.opposite());
    }

    @Override
    public IExpr opposite() {
        return IntegerSym.newInstance(this.fInteger.opposite());
    }

    @Override
    public IExpr plus(IExpr that) {
        if (that instanceof IntegerSym) {
            return this.add((IntegerSym)that);
        }
        if (this.isZero()) {
            return that;
        }
        if (that instanceof FractionSym) {
            return FractionSym.valueOf(this.fInteger).add((FractionSym)that);
        }
        return super.plus(that);
    }

    @Override
    public ISignedNumber minus(ISignedNumber that) {
        if (that instanceof IntegerSym) {
            return this.add((IntegerSym)that.negate());
        }
        if (this.isZero()) {
            return that.negate();
        }
        if (that instanceof FractionSym) {
            return FractionSym.valueOf(this.fInteger).minus(that);
        }
        return Num.valueOf(this.fInteger.doubleValue() - that.doubleValue());
    }

    @Override
    public IntegerSym pow(int exp) {
        return IntegerSym.newInstance(this.fInteger.pow(exp));
    }

    @Override
    public IExpr inverse() {
        if (this.fInteger.isNegative()) {
            return FractionSym.valueOf(BigInteger.valueOf(-1L), this.fInteger.opposite());
        }
        return FractionSym.valueOf(BigInteger.ONE, this.fInteger);
    }

    public BigInteger shiftLeft(int n) {
        return this.fInteger.shiftLeft(n);
    }

    public BigInteger shiftRight(int n) {
        return this.fInteger.shiftRight(n);
    }

    @Override
    public BigInteger subtract(BigInteger that) {
        return this.fInteger.minus(that);
    }

    @Override
    public IInteger subtract(IInteger that) {
        return IntegerSym.newInstance(this.fInteger.minus(that.getBigNumerator()));
    }

    @Override
    public IExpr times(IExpr that) {
        if (that instanceof IntegerSym) {
            return this.multiply((IntegerSym)that);
        }
        if (this.isZero()) {
            return F.C0;
        }
        if (that instanceof FractionSym) {
            return FractionSym.valueOf(this.fInteger).multiply((FractionSym)that);
        }
        return super.times(that);
    }

    public byte[] toByteArray() {
        return this.fInteger.toByteArray();
    }

    @Override
    public BigInteger getBigNumerator() {
        return this.fInteger;
    }

    @Override
    public IInteger getNumerator() {
        return this;
    }

    @Override
    public IInteger getDenominator() {
        return F.C1;
    }

    public List<IInteger> factorize() {
        ArrayList<IInteger> result = new ArrayList<IInteger>();
        IntegerSym b = this;
        if (this.sign() < 0) {
            b = b.multiply(IntegerSym.valueOf(-1L));
            result.add(IntegerSym.valueOf(-1L));
        }
        if (b.fInteger.equals(BigInteger.ZERO)) {
            result.add(IntegerSym.valueOf(0L));
            return result;
        }
        if (b.fInteger.equals(BigInteger.ONE)) {
            result.add(IntegerSym.valueOf(1L));
            return result;
        }
        TreeMap<Integer, Integer> map = new TreeMap<Integer, Integer>();
        BigInteger rest = Primality.countPrimes1021(b.fInteger, map);
        for (Map.Entry entry : map.entrySet()) {
            int key = (Integer)entry.getKey();
            IntegerSym is = IntegerSym.valueOf(key);
            int i = 0;
            while (i < (Integer)entry.getValue()) {
                result.add(is);
                ++i;
            }
        }
        if (rest.equals(BigInteger.ONE)) {
            return result;
        }
        b = IntegerSym.valueOf(rest);
        if (b.fInteger.isProbablePrime(32)) {
            result.add(b);
            return result;
        }
        IntegerSym p = IntegerSym.valueOf(1023L);
        while (true) {
            IntegerSym[] q;
            if ((q = b.divideAndRemainder(p))[0].compareTo(p) < 0) break;
            if (q[1].sign() == 0) {
                result.add(p);
                b = q[0];
                continue;
            }
            p = p.add(IntegerSym.valueOf(2L));
        }
        result.add(b);
        return result;
    }

    public IAST factorInteger() {
        IInteger last = IntegerSym.valueOf(-2L);
        int count = 0;
        List<IInteger> iFactors = this.factorize();
        IAST list = F.List();
        List subList = null;
        int i = 0;
        while (i < iFactors.size()) {
            IInteger factor = iFactors.get(i);
            if (!((Object)last).equals(factor)) {
                if (subList != null) {
                    subList.add(IntegerSym.valueOf(count));
                    list.add(subList);
                }
                count = 0;
                subList = F.List((IExpr)factor);
            }
            ++count;
            last = factor;
            ++i;
        }
        if (subList != null) {
            subList.add(IntegerSym.valueOf(count));
            list.add(subList);
        }
        return list;
    }

    public IInteger eulerPhi() throws ArithmeticException {
        IAST ast = this.factorInteger();
        IInteger phi = IntegerSym.valueOf(1L);
        int i = 1;
        while (i < ast.size()) {
            IAST element = (IAST)ast.get(i);
            IntegerSym q = (IntegerSym)element.get(1);
            int c = ((IInteger)element.get(2)).toInt();
            phi = c == 1 ? phi.multiply(q.subtract(IntegerSym.valueOf(1L))) : phi.multiply(q.subtract(IntegerSym.valueOf(1L)).multiply(q.pow(c - 1)));
            ++i;
        }
        return phi;
    }

    public IntegerSym moebiusMu() {
        if (this.compareTo(IntegerSym.valueOf(1L)) == 0) {
            return IntegerSym.valueOf(1L);
        }
        IAST ast = this.factorInteger();
        IntegerSym max = IntegerSym.valueOf(1L);
        int i = 1;
        while (i < ast.size()) {
            IAST element = (IAST)ast.get(i);
            IntegerSym c = (IntegerSym)element.get(2);
            if (c.compareTo(max) > 0) {
                max = c;
            }
            ++i;
        }
        if (max.compareTo(IntegerSym.valueOf(1L)) > 0) {
            return IntegerSym.valueOf(0L);
        }
        if ((ast.size() - 1 & 1) == 1) {
            return IntegerSym.valueOf(-1L);
        }
        return IntegerSym.valueOf(1L);
    }

    private IntegerSym jacobiSymbolF() {
        IntegerSym a = this.mod(IntegerSym.valueOf(8L));
        if (a.compareTo(IntegerSym.valueOf(1L)) == 0) {
            return IntegerSym.valueOf(1L);
        }
        if (a.compareTo(IntegerSym.valueOf(7L)) == 0) {
            return IntegerSym.valueOf(1L);
        }
        return IntegerSym.valueOf(-1L);
    }

    private IntegerSym jacobiSymbolG(IntegerSym i2) {
        IntegerSym a = this.mod(IntegerSym.valueOf(4L));
        if (a.compareTo(IntegerSym.valueOf(1L)) == 0) {
            return IntegerSym.valueOf(1L);
        }
        IntegerSym b = this.mod(IntegerSym.valueOf(4L));
        if (b.compareTo(IntegerSym.valueOf(1L)) == 0) {
            return IntegerSym.valueOf(1L);
        }
        return IntegerSym.valueOf(-1L);
    }

    public IntegerSym jacobiSymbol(IntegerSym b) {
        if (this.compareTo(IntegerSym.valueOf(1L)) == 0) {
            return IntegerSym.valueOf(1L);
        }
        if (this.compareTo(IntegerSym.valueOf(2L)) == 0) {
            return b.jacobiSymbolF();
        }
        if (!this.isOdd()) {
            return this.quotient(IntegerSym.valueOf(2L)).jacobiSymbol(b).multiply(IntegerSym.valueOf(2L).jacobiSymbol(b));
        }
        return b.quotient(this).jacobiSymbol(this).multiply(this.jacobiSymbolG(b));
    }

    public IInteger[] primitiveRoots() throws ArithmeticException {
        IntegerSym phi = (IntegerSym)this.eulerPhi();
        int size = phi.eulerPhi().toInt();
        if (size <= 0) {
            return null;
        }
        IAST ast = phi.factorInteger();
        IntegerSym[] d = new IntegerSym[ast.size() - 1];
        int i = 1;
        while (i < ast.size()) {
            IAST element = (IAST)ast.get(i);
            IntegerSym q = (IntegerSym)element.get(1);
            d[i - 1] = phi.quotient(q);
            ++i;
        }
        int k = 0;
        IntegerSym n = this;
        IntegerSym m = IntegerSym.valueOf(1L);
        IInteger[] resultArray = new IntegerSym[size];
        while (m.compareTo(n) < 0) {
            boolean b = m.gcd(n).compareTo(IntegerSym.valueOf(1L)) == 0;
            int i2 = 0;
            while (i2 < d.length) {
                b = b && m.modPow(d[i2], n).compareTo(IntegerSym.valueOf(1L)) > 0;
                ++i2;
            }
            if (b) {
                resultArray[k++] = m;
            }
            m = m.add(IntegerSym.valueOf(1L));
        }
        if (resultArray[0] == null) {
            return new IntegerSym[0];
        }
        return resultArray;
    }

    @Override
    public int compareTo(IntegerSym that) {
        return this.fInteger.compareTo(that.fInteger);
    }

    public IntegerSym[] divideAndRemainder(IntegerSym that) {
        IntegerSym[] res = new IntegerSym[2];
        BigInteger[] largeRes = this.fInteger.divideAndRemainder(that.fInteger);
        res[0] = IntegerSym.newInstance(largeRes[0]);
        res[1] = IntegerSym.newInstance(largeRes[1]);
        return res;
    }

    @Override
    public boolean isEven() {
        return this.fInteger.isEven();
    }

    @Override
    public boolean isOdd() {
        return this.fInteger.isOdd();
    }

    public IntegerSym modInverse(IntegerSym m) {
        return IntegerSym.newInstance(this.fInteger.modInverse(m.fInteger));
    }

    public IntegerSym modPow(IntegerSym exp, IntegerSym m) {
        return IntegerSym.newInstance(this.fInteger.modPow(exp.fInteger, m.fInteger));
    }

    @Override
    public int toInt() throws ArithmeticException {
        return this.fInteger.toInt();
    }

    public long toLong() throws ArithmeticException {
        return this.fInteger.toLong();
    }

    @Override
    public int sign() {
        return this.fInteger.signum();
    }

    public IInteger sqrt() {
        return this.nthRoot(2);
    }

    @Override
    public IInteger nthRoot(int n) throws ArithmeticException {
        IntegerSym result;
        if (this.sign() == 0) {
            return IntegerSym.valueOf(0L);
        }
        if (this.sign() < 0) {
            if (n % 2 == 0) {
                throw new ArithmeticException();
            }
            return (IntegerSym)((IntegerSym)this.negate()).nthRoot(n).negate();
        }
        IntegerSym temp = this;
        do {
            result = temp;
        } while ((temp = this.divideAndRemainder(temp.pow(n - 1))[0].add(temp.multiply(IntegerSym.valueOf(n - 1))).divideAndRemainder(IntegerSym.valueOf(n))[0]).compareTo(result) < 0);
        return result;
    }

    @Override
    public IInteger[] nthRootSplit(int n) throws ArithmeticException {
        IInteger[] result = new IInteger[2];
        if (this.sign() == 0) {
            result[0] = IntegerSym.valueOf(0L);
            result[1] = IntegerSym.valueOf(1L);
            return result;
        }
        if (this.sign() < 0) {
            if (n % 2 == 0) {
                throw new ArithmeticException();
            }
            result = ((IntegerSym)this.negate()).nthRootSplit(n);
            result[1] = (IInteger)result[1].negate();
            return result;
        }
        IntegerSym b = this;
        TreeMap<Integer, Integer> map = new TreeMap<Integer, Integer>();
        BigInteger rest = Primality.countPrimes1021(b.fInteger, map);
        result[0] = IntegerSym.valueOf(1L);
        result[1] = IntegerSym.valueOf(rest);
        for (Map.Entry entry : map.entrySet()) {
            IntegerSym is = IntegerSym.valueOf(((Integer)entry.getKey()).intValue());
            int val = (Integer)entry.getValue();
            int div = val / n;
            int mod = val % n;
            if (div > 0) {
                result[0] = result[0].multiply(is.pow(div));
            }
            if (mod <= 0) continue;
            result[1] = result[1].multiply(is.pow(mod));
        }
        return result;
    }

    @Override
    public int complexSign() {
        return this.sign();
    }

    @Override
    public ISignedNumber ceil() {
        return this;
    }

    @Override
    public ISignedNumber floor() {
        return this;
    }

    @Override
    public int compareTo(IExpr obj) {
        if (obj instanceof IntegerSym) {
            return this.fInteger.compareTo(((IntegerSym)obj).fInteger);
        }
        if (obj instanceof FractionSym) {
            return -((FractionSym)obj).fRational.compareTo(Rational.valueOf(this.fInteger, BigInteger.ONE));
        }
        return this.hierarchy() - obj.hierarchy();
    }

    @Override
    public boolean isLessThan(ISignedNumber obj) {
        if (obj instanceof IntegerSym) {
            return this.fInteger.compareTo(((IntegerSym)obj).fInteger) < 0;
        }
        if (obj instanceof FractionSym) {
            return -((FractionSym)obj).fRational.compareTo(Rational.valueOf(this.fInteger, BigInteger.ONE)) < 0;
        }
        return this.fInteger.doubleValue() < obj.doubleValue();
    }

    @Override
    public boolean isGreaterThan(ISignedNumber obj) {
        if (obj instanceof IntegerSym) {
            return this.fInteger.compareTo(((IntegerSym)obj).fInteger) > 0;
        }
        if (obj instanceof FractionSym) {
            return -((FractionSym)obj).fRational.compareTo(Rational.valueOf(this.fInteger, BigInteger.ONE)) > 0;
        }
        return this.fInteger.doubleValue() < obj.doubleValue();
    }

    @Override
    public ISymbol head() {
        return F.IntegerHead;
    }

    public static void main(String[] args) {
        IntegerSym i = IntegerSym.valueOf(84L);
        IInteger r = i.nthRoot(4);
        System.out.println(r);
    }

    public String toString() {
        return this.fInteger.toString();
    }

    @Override
    public String internalFormString(boolean callSymbolFactory) {
        int value = this.fInteger.toInt();
        switch (value) {
            case -1: {
                return "CN1";
            }
            case 0: {
                return "C0";
            }
            case 1: {
                return "C1";
            }
            case 2: {
                return "C2";
            }
            case 3: {
                return "C3";
            }
            case 4: {
                return "C4";
            }
            case 5: {
                return "C5";
            }
        }
        return "integer(" + value + "L)";
    }

    @Override
    public <T> T accept(IVisitor<T> visitor) {
        return visitor.visit(this);
    }

    @Override
    public boolean accept(IVisitorBoolean visitor) {
        return visitor.visit(this);
    }

    @Override
    public int accept(IVisitorInt visitor) {
        return visitor.visit(this);
    }
}

