/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.expression;

import org.matheclipse.core.eval.exception.DimensionException;
import org.matheclipse.core.expression.AST;
import org.matheclipse.core.expression.ASTDelegate;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.generic.BinaryMap;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IExpr;

public class Matrix
extends ASTDelegate {
    private final int fColumns;

    public Matrix(IAST ast, int columns) {
        super(ast);
        this.fColumns = columns;
    }

    public Matrix(int rows, int columns) {
        this.fColumns = columns;
        this.fAst = this.createAST(rows, columns);
    }

    public Matrix(int[][] values) {
        this.fColumns = values[0].length;
        this.fAst = this.createAST(values);
    }

    protected AST createAST(int rowSize, int columnSize) {
        AST matrix = (AST)F.ast(F.List, rowSize, true);
        int i = 1;
        while (i < rowSize + 1) {
            matrix.set(i, F.ast(F.List, columnSize, false));
            ++i;
        }
        return matrix;
    }

    protected AST createAST(int[][] values) {
        AST matrix = (AST)F.ast(F.List, values.length, true);
        int i = 0;
        while (i < values.length) {
            IAST row = F.ast(F.List, values[i].length, true);
            matrix.set(i + 1, row);
            int j = 0;
            while (j < values[i].length) {
                row.set(j + 1, F.integer(values[i][j]));
                ++j;
            }
            ++i;
        }
        return matrix;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Matrix) {
            Matrix other = (Matrix)obj;
            if (this.fColumns != other.fColumns) {
                return false;
            }
            return this.fAst.equals(other.fAst);
        }
        return false;
    }

    public IExpr getAt(int row, int column) {
        return (IExpr)((IAST)this.fAst.get(row)).get(column);
    }

    public IExpr setAt(int row, int column, IExpr value) {
        return ((IAST)this.fAst.get(row)).set(column, value);
    }

    public int getColumns() {
        return this.fColumns;
    }

    public int hashCode() {
        return this.fAst.hashCode() * 59;
    }

    public Matrix minus(Matrix that) {
        if (that.getRows() != this.getRows() || that.getColumns() != this.fColumns) {
            throw new DimensionException("Matrix#minus([" + this.getRows() + "," + this.fColumns + "],[" + that.getRows() + "," + that.getColumns() + "])");
        }
        return null;
    }

    public Matrix multiply(Matrix that) {
        if (that.getRows() != this.fColumns) {
            throw new DimensionException("Matrix#multiply([" + this.getRows() + "," + this.fColumns + "],[" + that.getRows() + "," + that.getColumns() + "])");
        }
        return null;
    }

    public Matrix plus(Matrix that) {
        if (that.getRows() != this.getRows() || that.getColumns() != this.fColumns) {
            throw new DimensionException("Matrix#plus([" + this.getRows() + "," + this.fColumns + "],[" + that.getRows() + "," + that.getColumns() + "])");
        }
        AST resultAST = this.createAST(this.fAst.size() - 1);
        int i = 1;
        while (i < this.fAst.size()) {
            AST tempAST = this.createAST(this.getColumns());
            ((IAST)this.fAst.get(i)).map(tempAST, (IAST)that.fAst.get(i), new BinaryMap(F.Plus()));
            resultAST.add(tempAST);
            ++i;
        }
        return new Matrix(resultAST, this.getColumns());
    }

    public Matrix power(Integer n) {
        return null;
    }
}

