/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.expression;

import org.matheclipse.core.expression.ExprImpl;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.INum;
import org.matheclipse.core.interfaces.ISignedNumber;
import org.matheclipse.core.interfaces.ISymbol;
import org.matheclipse.core.visit.IVisitor;
import org.matheclipse.core.visit.IVisitorBoolean;
import org.matheclipse.core.visit.IVisitorInt;

public class Num
extends ExprImpl
implements INum {
    private static final long serialVersionUID = 188084692735007429L;
    double fDouble;

    protected static Num newInstance(double value) {
        Num d = new Num(0.0);
        d.fDouble = value;
        return d;
    }

    private Num(double value) {
        this.fDouble = value;
    }

    @Override
    public int hierarchy() {
        return 2;
    }

    @Override
    public boolean isNegative() {
        return this.fDouble < 0.0;
    }

    @Override
    public boolean isPositive() {
        return this.fDouble > 0.0;
    }

    @Override
    public boolean equalsInt(int i) {
        return this.fDouble == (double)i;
    }

    @Override
    public INum add(INum val) {
        return Num.valueOf(this.fDouble + val.getRealPart());
    }

    @Override
    public INum multiply(INum val) {
        return Num.valueOf(this.fDouble * val.getRealPart());
    }

    @Override
    public INum pow(INum val) {
        return Num.valueOf(Math.pow(this.fDouble, val.getRealPart()));
    }

    public static double valueOf(String chars) {
        return Double.parseDouble(chars);
    }

    public static Num valueOf(double doubleValue) {
        return Num.newInstance(doubleValue);
    }

    @Override
    public Num eabs() {
        return Num.newInstance(Math.abs(this.fDouble));
    }

    public double plus(double that) {
        return this.fDouble + that;
    }

    @Override
    public IExpr plus(IExpr that) {
        if (that instanceof Num) {
            return this.add((Num)that);
        }
        return super.plus(that);
    }

    @Override
    public ISignedNumber minus(ISignedNumber that) {
        return Num.valueOf(this.doubleValue() - that.doubleValue());
    }

    @Override
    public int compareTo(double that) {
        return Double.compare(this.fDouble, that);
    }

    @Override
    public double divide(double that) {
        return this.fDouble / that;
    }

    @Override
    public double doubleValue() {
        return this.fDouble;
    }

    @Override
    public boolean equals(Object arg0) {
        if (this == arg0) {
            return true;
        }
        if (arg0 instanceof Num) {
            return this.fDouble == ((Num)arg0).fDouble;
        }
        return false;
    }

    @Override
    public boolean isSame(IExpr expression, double epsilon) {
        if (expression instanceof Num) {
            return F.isZero(this.fDouble - ((Num)expression).fDouble, epsilon);
        }
        return false;
    }

    public double exp() {
        return Math.exp(this.fDouble);
    }

    @Override
    public int hashCode() {
        return Double.valueOf(this.fDouble).hashCode();
    }

    public int intValue() {
        return Double.valueOf(this.fDouble).intValue();
    }

    public boolean isInfinite() {
        return Double.isInfinite(this.fDouble);
    }

    public boolean isNaN() {
        return Double.isNaN(this.fDouble);
    }

    public double log() {
        return Math.log(this.fDouble);
    }

    public long longValue() {
        return Double.valueOf(this.fDouble).longValue();
    }

    public double times(double that) {
        return this.fDouble * that;
    }

    @Override
    public IExpr times(IExpr that) {
        if (that instanceof Num) {
            return Num.newInstance(this.fDouble * ((Num)that).fDouble);
        }
        return super.times(that);
    }

    @Override
    public ISignedNumber negate() {
        return Num.newInstance(-this.fDouble);
    }

    @Override
    public IExpr opposite() {
        return Num.newInstance(-this.fDouble);
    }

    public double pow(double that) {
        return Math.pow(this.fDouble, that);
    }

    public double pow(int exp) {
        return Math.pow(this.fDouble, exp);
    }

    @Override
    public IExpr inverse() {
        return Num.newInstance(1.0 / this.fDouble);
    }

    public double sqrt() {
        return Math.sqrt(this.fDouble);
    }

    public double minus(double that) {
        return this.fDouble - that;
    }

    @Override
    public double getRealPart() {
        double temp = this.fDouble;
        if (temp == -0.0) {
            temp = 0.0;
        }
        return temp;
    }

    @Override
    public boolean isZero() {
        return F.isZero(this.fDouble);
    }

    @Override
    public boolean isOne() {
        return F.isZero(this.fDouble - 1.0);
    }

    @Override
    public int sign() {
        return (int)Math.signum(this.fDouble);
    }

    @Override
    public int complexSign() {
        return this.sign();
    }

    @Override
    public ISignedNumber ceil() {
        return Num.valueOf(Math.ceil(this.fDouble));
    }

    @Override
    public ISignedNumber floor() {
        return Num.valueOf(Math.floor(this.fDouble));
    }

    @Override
    public int compareTo(IExpr obj) {
        if (obj instanceof Num) {
            return Double.compare(this.fDouble, ((Num)obj).fDouble);
        }
        return this.hierarchy() - obj.hierarchy();
    }

    @Override
    public boolean isLessThan(ISignedNumber that) {
        return this.fDouble < that.doubleValue();
    }

    @Override
    public boolean isGreaterThan(ISignedNumber that) {
        return this.fDouble > that.doubleValue();
    }

    @Override
    public ISymbol head() {
        return F.RealHead;
    }

    public String toString() {
        if (this.fDouble == -0.0) {
            return "0.0";
        }
        return Double.valueOf(this.fDouble).toString();
    }

    @Override
    public <T> T accept(IVisitor<T> visitor) {
        return visitor.visit(this);
    }

    @Override
    public boolean accept(IVisitorBoolean visitor) {
        return visitor.visit(this);
    }

    @Override
    public int accept(IVisitorInt visitor) {
        return visitor.visit(this);
    }
}

