/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.expression;

import com.google.common.base.Predicate;
import java.util.List;
import java.util.Map;
import org.matheclipse.core.eval.EvalEngine;
import org.matheclipse.core.expression.ExprImpl;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.expression.Symbol;
import org.matheclipse.core.generic.Predicates;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.IPattern;
import org.matheclipse.core.interfaces.ISymbol;
import org.matheclipse.core.patternmatching.PatternMatcher;
import org.matheclipse.core.visit.IVisitor;
import org.matheclipse.core.visit.IVisitorBoolean;
import org.matheclipse.core.visit.IVisitorInt;

public class Pattern
extends ExprImpl
implements IPattern {
    private static final long serialVersionUID = 7617138748475243L;
    IExpr fCondition;
    int fIndex = 0;
    Symbol fSymbol;
    boolean fDefault = false;

    public static Pattern valueOf(Symbol symbol, IExpr check, boolean def) {
        Pattern p = new Pattern();
        p.fSymbol = symbol;
        p.fCondition = check;
        p.fIndex = 0;
        p.fDefault = def;
        return p;
    }

    public static Pattern valueOf(Symbol symbol, IExpr check) {
        Pattern p = new Pattern();
        p.fSymbol = symbol;
        p.fCondition = check;
        p.fIndex = 0;
        return p;
    }

    public static Pattern valueOf(Symbol symbol) {
        Pattern p = new Pattern();
        p.fSymbol = symbol;
        p.fCondition = null;
        p.fIndex = 0;
        return p;
    }

    private Pattern() {
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Pattern) {
            Pattern pattern = (Pattern)obj;
            if (this.fSymbol == null) {
                if (this.fCondition != null && pattern.fCondition != null) {
                    return pattern.fSymbol == null && this.fCondition.equals(pattern.fCondition);
                }
                return pattern.fSymbol == null && this.fCondition == pattern.fCondition;
            }
            if (pattern.fSymbol == null) {
                return false;
            }
            if (this.fCondition != null && pattern.fCondition != null) {
                return this.fSymbol.equals(pattern.fSymbol) && this.fCondition.equals(pattern.fCondition);
            }
            return this.fSymbol.equals(pattern.fSymbol) && this.fCondition == pattern.fCondition;
        }
        return false;
    }

    @Override
    public IExpr getCondition() {
        return this.fCondition;
    }

    @Override
    public int getIndex() {
        return this.fIndex;
    }

    @Override
    public ISymbol getSymbol() {
        return this.fSymbol;
    }

    @Override
    public int hashCode() {
        if (this.fSymbol == null) {
            return 199;
        }
        return this.fSymbol.hashCode();
    }

    @Override
    public int hierarchy() {
        return 512;
    }

    @Override
    public void setIndex(int i) {
        this.fIndex = i;
    }

    @Override
    public String internalFormString(boolean callSymbolFactory) {
        if (callSymbolFactory) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("pattern(");
            if (this.fSymbol == null) {
                buffer.append("null");
                if (this.fCondition != null) {
                    buffer.append("," + this.fCondition.internalFormString(callSymbolFactory));
                }
                if (this.fDefault) {
                    if (this.fCondition == null) {
                        buffer.append(",null");
                    }
                    buffer.append(",true");
                }
            } else {
                buffer.append("\"" + this.fSymbol.toString() + "\"");
                if (this.fCondition != null) {
                    buffer.append("," + this.fCondition.internalFormString(callSymbolFactory));
                }
                if (this.fDefault) {
                    if (this.fCondition == null) {
                        buffer.append(",null");
                    }
                    buffer.append(",true");
                }
            }
            buffer.append(")");
            return buffer.toString();
        }
        return this.toString();
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        if (this.fSymbol == null) {
            buffer.append('_');
            if (this.fDefault) {
                buffer.append('.');
            }
            if (this.fCondition != null) {
                buffer.append(this.fCondition.toString());
            }
        } else if (this.fCondition == null) {
            buffer.append(this.fSymbol.toString());
            buffer.append('_');
            if (this.fDefault) {
                buffer.append('.');
            }
        } else {
            buffer.append(this.fSymbol.toString());
            buffer.append('_');
            if (this.fDefault) {
                buffer.append('.');
            }
            buffer.append(this.fCondition.toString());
        }
        return buffer.toString();
    }

    @Override
    public String fullFormString() {
        StringBuffer buf = new StringBuffer();
        if (this.fSymbol == null) {
            buf.append("Blank[");
            if (this.fCondition != null) {
                buf.append(this.fCondition.fullFormString());
            }
            buf.append(']');
        } else {
            buf.append("Pattern[");
            buf.append(this.fSymbol.toString());
            buf.append(", ");
            buf.append("Blank[");
            if (this.fCondition != null) {
                buf.append(this.fCondition.fullFormString());
            }
            buf.append("]]");
        }
        return buf.toString();
    }

    @Override
    public int compareTo(IExpr obj) {
        if (obj instanceof Pattern) {
            int cp = this.fSymbol == null ? (((Pattern)obj).fSymbol == null ? -1 : 0) : (((Pattern)obj).fSymbol == null ? 1 : this.fSymbol.compareTo(((Pattern)obj).fSymbol));
            if (cp != 0) {
                return cp;
            }
            if (this.fCondition == null) {
                if (((Pattern)obj).fCondition != null) {
                    return -1;
                }
                return 0;
            }
            if (((Pattern)obj).fCondition == null) {
                return 1;
            }
            return this.fCondition.compareTo(((Pattern)obj).fCondition);
        }
        return this.hierarchy() - obj.hierarchy();
    }

    @Override
    public ISymbol head() {
        return F.PatternHead;
    }

    @Override
    public boolean isBlank() {
        return this.fSymbol == null;
    }

    @Override
    public boolean isConditionMatched(IExpr expr) {
        if (this.fCondition == null) {
            return true;
        }
        if (expr.head().equals(this.fCondition)) {
            return true;
        }
        EvalEngine engine = EvalEngine.get();
        boolean traceMode = false;
        try {
            traceMode = engine.isTraceMode();
            engine.setTraceMode(false);
            Predicate<IExpr> matcher = Predicates.isTrue(engine, this.fCondition);
            return matcher.apply((Object)expr);
            {
            }
        }
        finally {
            if (traceMode) {
                engine.setTraceMode(true);
            }
        }
    }

    @Override
    public IExpr variables2Slots(Map<IExpr, IExpr> map, List<IExpr> variableList) {
        return null;
    }

    @Override
    public <T> T accept(IVisitor<T> visitor) {
        return visitor.visit(this);
    }

    @Override
    public boolean accept(IVisitorBoolean visitor) {
        return visitor.visit(this);
    }

    @Override
    public int accept(IVisitorInt visitor) {
        return visitor.visit(this);
    }

    @Override
    public boolean isDefault() {
        return this.fDefault;
    }

    public boolean isCase(IExpr that) {
        PatternMatcher matcher = new PatternMatcher(this);
        return matcher.apply(that);
    }
}

