/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.expression;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.matheclipse.basic.Config;
import org.matheclipse.core.eval.EvalEngine;
import org.matheclipse.core.eval.SystemNamespace;
import org.matheclipse.core.eval.exception.RuleCreationError;
import org.matheclipse.core.expression.AST;
import org.matheclipse.core.expression.ExprImpl;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.form.output.OutputFormFactory;
import org.matheclipse.core.form.output.StringBufferWriter;
import org.matheclipse.core.generic.UnaryVariable2Slot;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IEvaluationEngine;
import org.matheclipse.core.interfaces.IEvaluator;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.IPatternMatcher;
import org.matheclipse.core.interfaces.ISymbol;
import org.matheclipse.core.patternmatching.PatternMatcher;
import org.matheclipse.core.patternmatching.PatternMatcherAndInvoker;
import org.matheclipse.core.patternmatching.RulesData;
import org.matheclipse.core.visit.IVisitor;
import org.matheclipse.core.visit.IVisitorBoolean;
import org.matheclipse.core.visit.IVisitorInt;

public class Symbol
extends ExprImpl
implements ISymbol {
    private static final long serialVersionUID = 7416359407349683408L;
    private static final int DEFAULT_VALUE_INDEX = Integer.MIN_VALUE;
    private int fAttributes = 0;
    private transient IEvaluator fEvaluator;
    private RulesData fRulesData = new RulesData();
    private Map<Integer, IExpr> fDefaultValues = null;
    private static final DummyEvaluator DUMMY_EVALUATOR = new DummyEvaluator();
    String fSymbolName;

    public Symbol(String symbolName) {
        this(symbolName, null);
    }

    protected Symbol() {
        this.fSymbolName = null;
        this.fEvaluator = null;
    }

    public Symbol(String symbolName, IEvaluator evaluator) {
        this.fSymbolName = symbolName;
        this.fEvaluator = evaluator;
    }

    @Override
    public IExpr apply(IExpr ... expressions) {
        return F.ast(expressions, this);
    }

    @Override
    public void pushLocalVariable() {
        this.pushLocalVariable(null);
    }

    @Override
    public void pushLocalVariable(IExpr expression) {
        Stack<IExpr> localVariableStack = EvalEngine.localStackCreate(this.fSymbolName);
        localVariableStack.push(expression);
    }

    @Override
    public void popLocalVariable() {
        Stack<IExpr> fLocalVariableStack = EvalEngine.localStack(this.fSymbolName);
        fLocalVariableStack.pop();
    }

    @Override
    public void clear(EvalEngine engine) {
        if (!engine.isPackageMode() && Config.SERVER_MODE && this.fSymbolName.charAt(0) != '$') {
            throw new RuleCreationError(null);
        }
        this.fRulesData.clear();
    }

    @Override
    public void clearAll(EvalEngine engine) {
        this.clear(engine);
        this.fAttributes = 0;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Symbol)) {
            return false;
        }
        return this.fSymbolName.equals(((Symbol)obj).fSymbolName);
    }

    @Override
    public IExpr evalDownRule(IEvaluationEngine ee, IExpr expression) {
        return this.fRulesData.evalDownRule(ee, expression);
    }

    @Override
    public int getAttributes() {
        return this.fAttributes;
    }

    @Override
    public IEvaluator getEvaluator() {
        if (this.fEvaluator == null) {
            this.fEvaluator = DUMMY_EVALUATOR;
            if (Character.isUpperCase(this.fSymbolName.charAt(0))) {
                SystemNamespace.DEFAULT.setEvaluator(this);
            }
        }
        return this.fEvaluator;
    }

    @Override
    public boolean hasLocalVariableStack() {
        Stack<IExpr> localVariableStack = EvalEngine.localStack(this.fSymbolName);
        return localVariableStack != null && !localVariableStack.isEmpty();
    }

    @Override
    public IExpr get() {
        Stack<IExpr> localVariableStack = EvalEngine.localStack(this.fSymbolName);
        if (localVariableStack == null) {
            return null;
        }
        return localVariableStack.peek();
    }

    @Override
    public void set(IExpr value) {
        Stack<IExpr> localVariableStack = EvalEngine.localStack(this.fSymbolName);
        localVariableStack.set(localVariableStack.size() - 1, value);
    }

    @Override
    public int hashCode() {
        return this.fSymbolName.hashCode();
    }

    @Override
    public int hierarchy() {
        return 128;
    }

    @Override
    public boolean isString(String str) {
        return this.fSymbolName.equals(str);
    }

    @Override
    public IPatternMatcher<IExpr> putDownRule(ISymbol symbol, boolean equalRule, IExpr leftHandSide, IExpr rightHandSide) {
        return this.putDownRule(symbol, equalRule, leftHandSide, rightHandSide, null, 100000);
    }

    @Override
    public IPatternMatcher<IExpr> putDownRule(ISymbol symbol, boolean equalRule, IExpr leftHandSide, IExpr rightHandSide, IExpr condition) {
        return this.putDownRule(symbol, equalRule, leftHandSide, rightHandSide, condition, 100000);
    }

    @Override
    public PatternMatcher putDownRule(ISymbol setSymbol, boolean equalRule, IExpr leftHandSide, IExpr rightHandSide, IExpr condition, int priority) {
        EvalEngine engine = EvalEngine.get();
        if (!engine.isPackageMode()) {
            if (Config.SERVER_MODE && this.fSymbolName.charAt(0) != '$') {
                throw new RuleCreationError(leftHandSide);
            }
            engine.addModifiedVariable(this);
        }
        return this.fRulesData.putDownRule(setSymbol, equalRule, leftHandSide, rightHandSide, condition, priority);
    }

    @Override
    public PatternMatcher putDownRule(PatternMatcherAndInvoker pmEvaluator) {
        return this.fRulesData.putDownRule(pmEvaluator);
    }

    @Override
    public void setAttributes(int attributes) {
        this.fAttributes = attributes;
        if (this.fSymbolName.charAt(0) == '$' && Config.SERVER_MODE) {
            EvalEngine engine = EvalEngine.get();
            engine.addModifiedVariable(this);
        }
    }

    @Override
    public void setEvaluator(IEvaluator evaluator) {
        this.fEvaluator = evaluator;
    }

    @Override
    public int compareTo(IExpr obj) {
        if (obj instanceof Symbol) {
            return this.fSymbolName.compareTo(((Symbol)obj).fSymbolName);
        }
        if (obj instanceof AST) {
            AST ast = (AST)obj;
            IExpr header = (IExpr)ast.head();
            if (ast.size() > 1) {
                if (header == F.Power && ast.size() == 3) {
                    if (ast.get(1) instanceof ISymbol) {
                        int cp = this.fSymbolName.compareTo(((Symbol)ast.get((int)1)).fSymbolName);
                        if (cp != 0) {
                            return cp;
                        }
                        if (EvalEngine.get().isNumericMode()) {
                            return F.CD1.compareTo((IExpr)ast.get(2));
                        }
                        return F.C1.compareTo((IExpr)ast.get(2));
                    }
                } else if (header == F.Times) {
                    IExpr lastTimesHeader;
                    IExpr lastTimes = (IExpr)ast.get(ast.size() - 1);
                    if (lastTimes instanceof AST && (lastTimesHeader = ((IAST)lastTimes).head()) == F.Power && ((IAST)lastTimes).size() == 3) {
                        int cp = this.compareTo((IExpr)((IAST)lastTimes).get(1));
                        if (cp != 0) {
                            return cp;
                        }
                        return F.C1.compareTo((IExpr)((IAST)lastTimes).get(2));
                    }
                    int cp = this.compareTo(lastTimes);
                    if (cp != 0) {
                        return cp;
                    }
                }
            }
            return -1;
        }
        return this.hierarchy() - obj.hierarchy();
    }

    @Override
    public boolean isAtom() {
        return true;
    }

    @Override
    public boolean isTrue() {
        return this.fSymbolName.equals("True");
    }

    @Override
    public boolean isValue() {
        return EvalEngine.get().evalSymbol(this) != null;
    }

    @Override
    public boolean isValue(IAST ast) {
        if (ast.head() instanceof ISymbol) {
            IExpr result = ((ISymbol)ast.head()).evalDownRule(EvalEngine.get(), ast);
            return result != null;
        }
        return false;
    }

    @Override
    public boolean isFalse() {
        return this.fSymbolName.equals("False");
    }

    @Override
    public ISymbol head() {
        return F.SymbolHead;
    }

    public String getSymbol() {
        return this.fSymbolName;
    }

    @Override
    public IExpr variables2Slots(Map<IExpr, IExpr> map, List<IExpr> variableList) {
        UnaryVariable2Slot uv2s = new UnaryVariable2Slot(map, variableList);
        return uv2s.apply(this);
    }

    @Override
    public String internalFormString(boolean callSymbolFactory) {
        if (callSymbolFactory) {
            return "symbol(\"" + this.fSymbolName + "\")";
        }
        return this.fSymbolName;
    }

    public String toString() {
        return this.fSymbolName;
    }

    @Override
    public List<IAST> definition() {
        return this.fRulesData.definition();
    }

    @Override
    public IExpr getDefaultValue() {
        if (this.fDefaultValues == null) {
            return null;
        }
        return this.fDefaultValues.get(Integer.MIN_VALUE);
    }

    @Override
    public IExpr getDefaultValue(int pos) {
        if (this.fDefaultValues == null) {
            return null;
        }
        return this.fDefaultValues.get(pos);
    }

    @Override
    public void setDefaultValue(IExpr expr) {
        if (this.fDefaultValues == null) {
            this.fDefaultValues = new HashMap<Integer, IExpr>();
        }
        this.fDefaultValues.put(Integer.MIN_VALUE, expr);
    }

    @Override
    public void setDefaultValue(int pos, IExpr expr) {
        if (this.fDefaultValues == null) {
            this.fDefaultValues = new HashMap<Integer, IExpr>();
        }
        this.fDefaultValues.put(pos, expr);
    }

    @Override
    public String definitionToString() throws IOException {
        StringBufferWriter buf = new StringBufferWriter();
        buf.setIgnoreNewLine(true);
        List<IAST> list = this.definition();
        buf.append("{");
        int i = 0;
        while (i < list.size()) {
            OutputFormFactory.get().convert(buf, list.get(i));
            if (i < list.size() - 1) {
                buf.append(",\n ");
            }
            ++i;
        }
        buf.append("}\n");
        return buf.toString();
    }

    @Override
    public void readSymbol(ObjectInputStream stream) throws IOException {
        this.fSymbolName = stream.readUTF();
        this.fAttributes = stream.read();
        this.fRulesData.readSymbol(stream);
    }

    @Override
    public void writeSymbol(ObjectOutputStream stream) throws IOException {
        stream.writeUTF(this.fSymbolName);
        stream.write(this.fAttributes);
        this.fRulesData.writeSymbol(stream);
    }

    @Override
    public <T> T accept(IVisitor<T> visitor) {
        return visitor.visit(this);
    }

    @Override
    public boolean accept(IVisitorBoolean visitor) {
        return visitor.visit(this);
    }

    @Override
    public int accept(IVisitorInt visitor) {
        return visitor.visit(this);
    }

    static class DummyEvaluator
    implements IEvaluator {
        DummyEvaluator() {
        }

        @Override
        public void setUp(ISymbol symbol) {
        }
    }
}

