/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.form.java;

import java.util.Hashtable;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.IInteger;
import org.matheclipse.core.interfaces.INum;
import org.matheclipse.core.interfaces.ISymbol;

public class JavaFormFactory {
    public final Hashtable<String, String> CONSTANT_SYMBOLS = new Hashtable(199);
    private String fTypeName;

    public JavaFormFactory(String typeName) {
        this.fTypeName = typeName;
        this.init();
    }

    private void init() {
        this.CONSTANT_SYMBOLS.put("Times", "multiply");
        this.CONSTANT_SYMBOLS.put("Plus", "add");
        this.CONSTANT_SYMBOLS.put("PrimeQ", "isProbablePrime");
    }

    public void convertHead(StringBuffer buf, IExpr expr) {
        if (expr instanceof ISymbol) {
            String ho = this.CONSTANT_SYMBOLS.get(((ISymbol)expr).toString());
            if (ho != null) {
                buf.append(ho);
            } else {
                String eStr = expr.toString();
                buf.append(Character.toLowerCase(eStr.charAt(0)));
                buf.append(eStr.substring(1));
            }
            return;
        }
        this.convert(buf, expr);
    }

    public void convertAST(StringBuffer buf, IAST f) {
        if (f.size() == 1) {
            this.convertHead(buf, f.head());
            buf.append("()");
        } else if (f.size() == 2) {
            this.convert(buf, (IExpr)f.get(1));
            buf.append(".");
            this.convertHead(buf, f.head());
            buf.append("()");
        } else {
            int i = 2;
            while (i < f.size()) {
                this.convert(buf, (IExpr)f.get(i));
                f.size();
                ++i;
            }
        }
    }

    public void convert(StringBuffer buf, IExpr o) {
        if (o instanceof IAST) {
            IAST f = (IAST)o;
            this.convertAST(buf, f);
            return;
        }
        if (o instanceof INum) {
            buf.append(o.toString());
            return;
        }
        if (o instanceof IInteger) {
            buf.append(o.toString());
            return;
        }
        if (o instanceof ISymbol) {
            buf.append(o.toString());
            return;
        }
    }
}

