/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.form.mathml;

import org.matheclipse.core.form.mathml.AbstractConverter;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IExpr;

public abstract class AbstractOperator
extends AbstractConverter {
    protected int fPrecedence;
    protected String fFirstTag;
    protected String fOperator;

    public AbstractOperator(int precedence, String firstTag, String oper) {
        this.fPrecedence = precedence;
        this.fFirstTag = firstTag;
        this.fOperator = oper;
    }

    public AbstractOperator(int precedence, String oper) {
        this(precedence, "mrow", oper);
    }

    public void precedenceOpen(StringBuffer buf, int precedence) {
        if (precedence > this.fPrecedence) {
            this.fFactory.tagStart(buf, "mrow");
            this.fFactory.tag(buf, "mo", "(");
        }
    }

    public void precedenceClose(StringBuffer buf, int precedence) {
        if (precedence > this.fPrecedence) {
            this.fFactory.tag(buf, "mo", ")");
            this.fFactory.tagEnd(buf, "mrow");
        }
    }

    @Override
    public boolean convert(StringBuffer buf, IAST f, int precedence) {
        this.fFactory.tagStart(buf, this.fFirstTag);
        this.precedenceOpen(buf, precedence);
        int i = 1;
        while (i < f.size()) {
            this.fFactory.convert(buf, (IExpr)f.get(i), this.fPrecedence);
            if (i < f.size() - 1 && this.fOperator.compareTo("") != 0) {
                this.fFactory.tag(buf, "mo", this.fOperator);
            }
            ++i;
        }
        this.precedenceClose(buf, precedence);
        this.fFactory.tagEnd(buf, this.fFirstTag);
        return true;
    }
}

