/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.form.mathml;

import apache.harmony.math.BigInteger;
import apache.harmony.math.Rational;
import java.util.Hashtable;
import org.matheclipse.core.expression.IConstantHeaders;
import org.matheclipse.core.form.mathml.AbstractConverter;
import org.matheclipse.core.form.mathml.AbstractMathMLFormFactory;
import org.matheclipse.core.form.mathml.IConverter;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IComplex;
import org.matheclipse.core.interfaces.IComplexNum;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.IFraction;
import org.matheclipse.core.interfaces.IInteger;
import org.matheclipse.core.interfaces.INum;
import org.matheclipse.core.interfaces.ISymbol;
import org.matheclipse.parser.client.operator.ASTNodeFactory;

public class MathMLContentFormFactory
extends AbstractMathMLFormFactory
implements IConstantHeaders {
    public final Hashtable<String, Object> CONSTANT_SYMBOLS = new Hashtable(199);
    public final Hashtable<String, AbstractConverter> operTab = new Hashtable(199);
    private int plusPrec;

    public MathMLContentFormFactory() {
        this("");
    }

    public MathMLContentFormFactory(String tagPrefix) {
        super(tagPrefix);
        this.init();
    }

    @Override
    public void convertDouble(StringBuffer buf, INum d, int precedence) {
        if (d.isNegative() && precedence > this.plusPrec) {
            this.tagStart(buf, "mrow");
            this.tag(buf, "mo", "(");
        }
        this.tagStart(buf, "mn");
        buf.append(d.toString());
        this.tagEnd(buf, "mn");
        if (d.isNegative() && precedence > this.plusPrec) {
            this.tag(buf, "mo", ")");
            this.tagEnd(buf, "mrow");
        }
    }

    @Override
    public void convertDoubleComplex(StringBuffer buf, IComplexNum dc, int precedence) {
        this.tagStart(buf, "mrow");
        buf.append(String.valueOf(dc.getRealPart()));
        this.tag(buf, "mo", "+");
        this.tagStart(buf, "mrow");
        buf.append(String.valueOf(dc.getImaginaryPart()));
        this.tag(buf, "mo", "&InvisibleTimes;");
        this.tag(buf, "mi", "&#x02148;");
        this.tagEnd(buf, "mrow");
        this.tagEnd(buf, "mrow");
    }

    @Override
    public void convertInteger(StringBuffer buf, IInteger i, int precedence) {
        if (i.isNegative() && precedence > this.plusPrec) {
            this.tagStart(buf, "mrow");
            this.tag(buf, "mo", "(");
        }
        this.tagStart(buf, "mn");
        buf.append(i.getBigNumerator().toString());
        this.tagEnd(buf, "mn");
        if (i.isNegative() && precedence > this.plusPrec) {
            this.tag(buf, "mo", ")");
            this.tagEnd(buf, "mrow");
        }
    }

    @Override
    public void convertFraction(StringBuffer buf, IFraction f, int precedence) {
        if (f.isNegative() && precedence > this.plusPrec) {
            this.tagStart(buf, "mrow");
            this.tag(buf, "mo", "(");
        }
        this.tagStart(buf, "mfrac");
        this.tagStart(buf, "mn");
        buf.append(f.getBigNumerator().toString());
        this.tagEnd(buf, "mn");
        this.tagStart(buf, "mn");
        buf.append(f.getBigDenominator().toString());
        this.tagEnd(buf, "mn");
        this.tagEnd(buf, "mfrac");
        if (f.isNegative() && precedence > this.plusPrec) {
            this.tag(buf, "mo", ")");
            this.tagEnd(buf, "mrow");
        }
    }

    public void convertFraction(StringBuffer buf, Rational f, int precedence) {
        if (f.isNegative() && precedence > this.plusPrec) {
            this.tagStart(buf, "mrow");
            this.tag(buf, "mo", "(");
        }
        if (f.getDenominator().equals(BigInteger.ONE)) {
            this.tagStart(buf, "mn");
            buf.append(f.getNumerator().toString());
            this.tagEnd(buf, "mn");
        } else {
            this.tagStart(buf, "mfrac");
            this.tagStart(buf, "mn");
            buf.append(f.getNumerator().toString());
            this.tagEnd(buf, "mn");
            this.tagStart(buf, "mn");
            buf.append(f.getDenominator().toString());
            this.tagEnd(buf, "mn");
            this.tagEnd(buf, "mfrac");
        }
        if (f.isNegative() && precedence > this.plusPrec) {
            this.tag(buf, "mo", ")");
            this.tagEnd(buf, "mrow");
        }
    }

    @Override
    public void convertComplex(StringBuffer buf, IComplex c, int precedence) {
        this.tagStart(buf, "mrow");
        this.convertFraction(buf, c.getRealPart(), precedence);
        this.tag(buf, "mo", "+");
        this.tagStart(buf, "mrow");
        this.convertFraction(buf, c.getImaginaryPart(), 3800);
        this.tag(buf, "mo", "&InvisibleTimes;");
        this.tag(buf, "mi", "&#x02148;");
        this.tagEnd(buf, "mrow");
        this.tagEnd(buf, "mrow");
    }

    @Override
    public void convertString(StringBuffer buf, String str) {
        this.tagStart(buf, "mtext");
        buf.append(str);
        this.tagEnd(buf, "mtext");
    }

    @Override
    public void convertSymbol(StringBuffer buf, ISymbol sym) {
        Object convertedSymbol = this.CONSTANT_SYMBOLS.get(sym.toString());
        if (convertedSymbol == null) {
            this.tagStart(buf, "mi");
            buf.append(sym.toString());
            this.tagEnd(buf, "mi");
        } else if (convertedSymbol.equals("True")) {
            this.tagStart(buf, "mi");
            buf.append("&");
            buf.append(sym.toString());
            buf.append(";");
            this.tagEnd(buf, "mi");
        } else if (convertedSymbol instanceof Operator) {
            ((Operator)convertedSymbol).convert(buf);
        } else {
            this.tagStart(buf, "mi");
            buf.append(convertedSymbol.toString());
            this.tagEnd(buf, "mi");
        }
    }

    @Override
    public void convertHead(StringBuffer buf, IExpr obj) {
        if (obj instanceof ISymbol) {
            Object ho = this.CONSTANT_SYMBOLS.get(((ISymbol)obj).toString());
            this.tagStart(buf, "mi");
            if (ho != null && ho.equals("True")) {
                buf.append("&");
            }
            buf.append(((ISymbol)obj).toString());
            this.tagEnd(buf, "mi");
            this.tag(buf, "mo", "&af;");
            return;
        }
        this.convert(buf, obj, 0);
    }

    @Override
    public void convert(StringBuffer buf, IExpr o, int precedence) {
        if (o instanceof IAST) {
            IAST f = (IAST)o;
            IConverter converter = this.reflection(f.head().toString());
            if (converter == null || !converter.convert(buf, f, precedence)) {
                this.convertHeadList(buf, f);
            }
            return;
        }
        if (o instanceof INum) {
            this.convertDouble(buf, (INum)o, precedence);
            return;
        }
        if (o instanceof IComplexNum) {
            this.convertDoubleComplex(buf, (IComplexNum)o, precedence);
            return;
        }
        if (o instanceof IInteger) {
            this.convertInteger(buf, (IInteger)o, precedence);
            return;
        }
        if (o instanceof IFraction) {
            this.convertFraction(buf, (IFraction)o, precedence);
            return;
        }
        if (o instanceof IComplex) {
            this.convertComplex(buf, (IComplex)o, precedence);
            return;
        }
        if (o instanceof ISymbol) {
            this.convertSymbol(buf, (ISymbol)o);
            return;
        }
        this.convertString(buf, o.toString());
    }

    private void convertHeadList(StringBuffer buf, IAST f) {
        this.tagStart(buf, "mrow");
        this.convertHead(buf, f.head());
        this.tag(buf, "mo", "&af;");
        this.tagStart(buf, "mrow");
        this.tag(buf, "mo", "(");
        this.tagStart(buf, "mrow");
        int i = 1;
        while (i < f.size()) {
            this.convert(buf, (IExpr)f.get(i), 0);
            if (i < f.size() - 1) {
                this.tag(buf, "mo", ",");
            }
            ++i;
        }
        this.tagEnd(buf, "mrow");
        this.tag(buf, "mo", ")");
        this.tagEnd(buf, "mrow");
        this.tagEnd(buf, "mrow");
    }

    @Override
    public String getReflectionNamespace() {
        return "org.matheclipse.core.form.mathml.reflection.";
    }

    @Override
    public IConverter reflection(String headString) {
        IConverter converter = this.operTab.get(headString);
        if (converter != null) {
            return converter;
        }
        String namespace = String.valueOf(this.getReflectionNamespace()) + headString;
        Class<?> clazz = null;
        try {
            clazz = Class.forName(namespace);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
        try {
            AbstractConverter module = (AbstractConverter)clazz.newInstance();
            module.setFactory(this);
            this.operTab.put(headString, module);
            return module;
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public void init() {
        this.plusPrec = ASTNodeFactory.MMA_STYLE_FACTORY.get("Plus").getPrecedence();
        this.CONSTANT_SYMBOLS.put("E", "&#02147;");
        this.CONSTANT_SYMBOLS.put("I", "&#x02148;");
        this.CONSTANT_SYMBOLS.put("HEllipsis", new Operator("&hellip;"));
        this.CONSTANT_SYMBOLS.put("Pi", "&pi;");
        this.CONSTANT_SYMBOLS.put("Alpha", "True");
        this.CONSTANT_SYMBOLS.put("Beta", "True");
        this.CONSTANT_SYMBOLS.put("Chi", "True");
        this.CONSTANT_SYMBOLS.put("Delta", "True");
        this.CONSTANT_SYMBOLS.put("Epsilon", "True");
        this.CONSTANT_SYMBOLS.put("Phi", "True");
        this.CONSTANT_SYMBOLS.put("Gamma", "True");
        this.CONSTANT_SYMBOLS.put("Eta", "True");
        this.CONSTANT_SYMBOLS.put("Iota", "True");
        this.CONSTANT_SYMBOLS.put("varTheta", "True");
        this.CONSTANT_SYMBOLS.put("Kappa", "True");
        this.CONSTANT_SYMBOLS.put("Lambda", "True");
        this.CONSTANT_SYMBOLS.put("Mu", "True");
        this.CONSTANT_SYMBOLS.put("Nu", "True");
        this.CONSTANT_SYMBOLS.put("Omicron", "True");
        this.CONSTANT_SYMBOLS.put("Theta", "True");
        this.CONSTANT_SYMBOLS.put("Rho", "True");
        this.CONSTANT_SYMBOLS.put("Sigma", "True");
        this.CONSTANT_SYMBOLS.put("Tau", "True");
        this.CONSTANT_SYMBOLS.put("Upsilon", "True");
        this.CONSTANT_SYMBOLS.put("Omega", "True");
        this.CONSTANT_SYMBOLS.put("Xi", "True");
        this.CONSTANT_SYMBOLS.put("Psi", "True");
        this.CONSTANT_SYMBOLS.put("Zeta", "True");
        this.CONSTANT_SYMBOLS.put("alpha", "True");
        this.CONSTANT_SYMBOLS.put("beta", "True");
        this.CONSTANT_SYMBOLS.put("chi", "True");
        this.CONSTANT_SYMBOLS.put("selta", "True");
        this.CONSTANT_SYMBOLS.put("epsilon", "True");
        this.CONSTANT_SYMBOLS.put("phi", "True");
        this.CONSTANT_SYMBOLS.put("gamma", "True");
        this.CONSTANT_SYMBOLS.put("eta", "True");
        this.CONSTANT_SYMBOLS.put("iota", "True");
        this.CONSTANT_SYMBOLS.put("varphi", "True");
        this.CONSTANT_SYMBOLS.put("kappa", "True");
        this.CONSTANT_SYMBOLS.put("lambda", "True");
        this.CONSTANT_SYMBOLS.put("mu", "True");
        this.CONSTANT_SYMBOLS.put("nu", "True");
        this.CONSTANT_SYMBOLS.put("omicron", "True");
        this.CONSTANT_SYMBOLS.put("theta", "True");
        this.CONSTANT_SYMBOLS.put("rho", "True");
        this.CONSTANT_SYMBOLS.put("sigma", "True");
        this.CONSTANT_SYMBOLS.put("tau", "True");
        this.CONSTANT_SYMBOLS.put("upsilon", "True");
        this.CONSTANT_SYMBOLS.put("varomega", "True");
        this.CONSTANT_SYMBOLS.put("omega", "True");
        this.CONSTANT_SYMBOLS.put("xi", "True");
        this.CONSTANT_SYMBOLS.put("psi", "True");
        this.CONSTANT_SYMBOLS.put("zeta", "True");
        ENTITY_TABLE.put("&af;", "&#xE8A0;");
        ENTITY_TABLE.put("&dd;", "&#xF74C;");
        ENTITY_TABLE.put("&InvisibleTimes;", "&#xE89E;");
        ENTITY_TABLE.put("&Integral;", "&#x222B;");
        ENTITY_TABLE.put("&PartialD;", "&#x2202;");
        ENTITY_TABLE.put("&Product;", "&#x220F;");
    }

    private class Operator {
        String fOperator;

        Operator(String oper) {
            this.fOperator = oper;
        }

        public void convert(StringBuffer buf) {
            MathMLContentFormFactory.this.tagStart(buf, "mo");
            buf.append(this.fOperator);
            MathMLContentFormFactory.this.tagEnd(buf, "mo");
        }

        public String toString() {
            return this.fOperator;
        }
    }
}

