/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.form.mathml.reflection;

import org.matheclipse.core.form.mathml.AbstractConverter;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IExpr;

public class MatrixForm
extends AbstractConverter {
    @Override
    public boolean convert(StringBuffer buf, IAST f, int precedence) {
        if (f.size() != 2) {
            return false;
        }
        IAST matrix = this.matrixQ((IExpr)f.get(1));
        if (matrix == null) {
            IAST vector = this.vectorQ((IExpr)f.get(1));
            if (vector == null) {
                return false;
            }
            this.fFactory.tagStart(buf, "mrow");
            this.fFactory.tag(buf, "mo", "(");
            this.fFactory.tagStart(buf, "mtable");
            int i = 1;
            while (i < vector.size()) {
                IExpr temp = (IExpr)vector.get(i);
                this.fFactory.tagStart(buf, "mtr");
                this.fFactory.tagStart(buf, "mtd");
                this.fFactory.convert(buf, temp, 0);
                this.fFactory.tagEnd(buf, "mtd");
                this.fFactory.tagEnd(buf, "mtr");
                ++i;
            }
            this.fFactory.tagEnd(buf, "mtable");
            this.fFactory.tag(buf, "mo", ")");
            this.fFactory.tagEnd(buf, "mrow");
        } else {
            this.fFactory.tagStart(buf, "mrow");
            this.fFactory.tag(buf, "mo", "(");
            this.fFactory.tagStart(buf, "mtable");
            int i = 1;
            while (i < matrix.size()) {
                IAST temp = (IAST)matrix.get(i);
                this.fFactory.tagStart(buf, "mtr");
                int j = 1;
                while (j < temp.size()) {
                    this.fFactory.tagStart(buf, "mtd");
                    this.fFactory.convert(buf, (IExpr)temp.get(j), 0);
                    this.fFactory.tagEnd(buf, "mtd");
                    ++j;
                }
                this.fFactory.tagEnd(buf, "mtr");
                ++i;
            }
            this.fFactory.tagEnd(buf, "mtable");
            this.fFactory.tag(buf, "mo", ")");
            this.fFactory.tagEnd(buf, "mrow");
        }
        return true;
    }

    public IAST matrixQ(IExpr expr) {
        if (!(expr instanceof IAST)) {
            return null;
        }
        IAST list = (IAST)expr;
        if (!list.topHead().toString().equals("List")) {
            return null;
        }
        int size = list.size();
        int subSize = -1;
        int i = 1;
        while (i < size) {
            IExpr temp = (IExpr)list.get(i);
            if (!(temp instanceof IAST)) {
                return null;
            }
            IAST subList = (IAST)temp;
            if (!subList.topHead().toString().equals("List")) {
                return null;
            }
            if (subSize < 0) {
                subSize = subList.size();
            } else if (subSize != subList.size()) {
                return null;
            }
            ++i;
        }
        return list;
    }

    public IAST vectorQ(IExpr expr) {
        if (!(expr instanceof IAST)) {
            return null;
        }
        IAST list = (IAST)expr;
        if (!list.topHead().toString().equals("List")) {
            return null;
        }
        int size = list.size();
        int i = 1;
        while (i < size) {
            IExpr temp = (IExpr)list.get(i);
            if (temp instanceof IAST && ((IAST)temp).topHead().toString().equals("List")) {
                return null;
            }
            ++i;
        }
        return list;
    }
}

