/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.form.output;

import apache.harmony.math.BigInteger;
import apache.harmony.math.Rational;
import java.io.IOException;
import java.io.Writer;
import java.util.Map;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.expression.IConstantHeaders;
import org.matheclipse.core.form.output.StringBufferWriter;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IComplex;
import org.matheclipse.core.interfaces.IComplexNum;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.IFraction;
import org.matheclipse.core.interfaces.IInteger;
import org.matheclipse.core.interfaces.INum;
import org.matheclipse.core.interfaces.INumber;
import org.matheclipse.core.interfaces.IPattern;
import org.matheclipse.core.interfaces.ISignedNumber;
import org.matheclipse.core.interfaces.ISymbol;
import org.matheclipse.parser.client.operator.ASTNodeFactory;
import org.matheclipse.parser.client.operator.InfixOperator;
import org.matheclipse.parser.client.operator.Operator;
import org.matheclipse.parser.client.operator.PostfixOperator;
import org.matheclipse.parser.client.operator.PrefixOperator;

public class OutputFormFactory
implements IConstantHeaders {
    private boolean fRelaxedSyntax;

    private OutputFormFactory(boolean relaxedSyntax) {
        this.fRelaxedSyntax = relaxedSyntax;
    }

    public static OutputFormFactory get(boolean relaxedSyntax) {
        return new OutputFormFactory(relaxedSyntax);
    }

    public static OutputFormFactory get() {
        return OutputFormFactory.get(false);
    }

    public void convertDouble(Writer buf, INum d, int precedence) throws IOException {
        boolean isNegative = d.isNegative();
        this.convertDoubleValue(buf, d.toString(), precedence, isNegative);
    }

    private void convertDoubleValue(Writer buf, String d, int precedence, boolean isNegative) throws IOException {
        if (isNegative && 2900 < precedence) {
            buf.write("(");
        }
        buf.write(d);
        if (isNegative && 2900 < precedence) {
            buf.write(")");
        }
    }

    public void convertDoubleComplex(Writer buf, IComplexNum dc, int precedence) throws IOException {
        if (2900 < precedence) {
            buf.write("(");
        }
        double realPart = dc.getRealPart();
        buf.write(String.valueOf(realPart));
        buf.write("+I*");
        boolean isNegative = dc.getImaginaryPart() < 0.0;
        this.convertDoubleValue(buf, String.valueOf(dc.getImaginaryPart()), 3800, isNegative);
        if (2900 < precedence) {
            buf.write(")");
        }
    }

    public void convertInteger(Writer buf, IInteger i, int precedence) throws IOException {
        boolean isNegative = i.isNegative();
        StringBufferWriter sbw = null;
        if (buf instanceof StringBufferWriter) {
            sbw = (StringBufferWriter)buf;
        }
        if (isNegative && 2900 < precedence) {
            buf.write("(");
        }
        String str = i.getBigNumerator().toString();
        if (sbw != null && str.length() + sbw.getColumnCounter() > 80) {
            if (sbw.getColumnCounter() > 40) {
                sbw.newLine();
            }
            int len = str.length();
            int j = 0;
            while (j < len) {
                if (j + 79 < len) {
                    sbw.write(str.substring(j, j + 79));
                    sbw.write(92);
                    sbw.newLine();
                } else {
                    buf.write(str.substring(j, len));
                }
                j += 79;
            }
        } else {
            buf.write(str);
        }
        if (isNegative && 2900 < precedence) {
            buf.write(")");
        }
    }

    public void convertFraction(Writer buf, Rational f, int precedence) throws IOException {
        int j;
        int len;
        int prec;
        boolean isInteger = f.getDenominator().compareTo(BigInteger.ONE) == 0;
        boolean isNegative = f.getNumerator().compareTo(BigInteger.ZERO) < 0;
        int n = prec = isNegative ? 2900 : 3800;
        if (prec < precedence) {
            buf.write("(");
        }
        StringBufferWriter sbw = null;
        if (buf instanceof StringBufferWriter) {
            sbw = (StringBufferWriter)buf;
        }
        String str = f.getNumerator().toString();
        if (sbw != null && str.length() + sbw.getColumnCounter() > 80) {
            if (sbw.getColumnCounter() > 40) {
                sbw.newLine();
            }
            len = str.length();
            j = 0;
            while (j < len) {
                if (j + 79 < len) {
                    buf.write(str.substring(j, j + 79));
                    buf.write(92);
                    sbw.newLine();
                } else {
                    buf.write(str.substring(j, len));
                }
                j += 79;
            }
        } else {
            buf.write(str);
        }
        if (!isInteger) {
            buf.write("/");
            str = f.getDenominator().toString();
            if (sbw != null && str.length() + sbw.getColumnCounter() > 80) {
                if (sbw.getColumnCounter() > 40) {
                    sbw.newLine();
                }
                len = str.length();
                j = 0;
                while (j < len) {
                    if (j + 79 < len) {
                        buf.write(str.substring(j, j + 79));
                        buf.write(92);
                        sbw.newLine();
                    } else {
                        buf.write(str.substring(j, len));
                    }
                    j += 79;
                }
            } else {
                buf.write(str);
            }
        }
        if (prec < precedence) {
            buf.write(")");
        }
    }

    public void convertComplex(Writer buf, IComplex c, int precedence) throws IOException {
        boolean isImMinusOne;
        boolean isReZero = c.getRealPart().compareTo(Rational.ZERO) == 0;
        boolean isImOne = c.getImaginaryPart().compareTo(Rational.ONE) == 0;
        boolean isImNegative = c.getImaginaryPart().compareTo(Rational.ZERO) < 0;
        boolean bl = isImMinusOne = isImNegative && c.getImaginaryPart().compareTo(Rational.valueOf(-1L, 1L)) == 0;
        if (!isReZero && 2900 < precedence) {
            buf.write("(");
        }
        if (!isReZero) {
            this.convertFraction(buf, c.getRealPart(), 2900);
        }
        if (isImOne) {
            if (isReZero) {
                buf.write("I");
                return;
            }
            buf.write("+I");
        } else if (isImMinusOne) {
            buf.write("-I");
        } else {
            Rational im;
            if (isReZero && 3800 < precedence) {
                buf.write("(");
            }
            if (Rational.ZERO.isLargerThan(im = c.getImaginaryPart())) {
                buf.write("-I*");
                this.convertFraction(buf, c.getImaginaryPart().opposite(), 3800);
            } else {
                if (isReZero) {
                    buf.write("I*");
                } else {
                    buf.write("+I*");
                }
                this.convertFraction(buf, c.getImaginaryPart(), 3800);
            }
            if (isReZero && 3800 < precedence) {
                buf.write(")");
            }
        }
        if (!isReZero && 2900 < precedence) {
            buf.write(")");
        }
    }

    public void convertString(Writer buf, String str) throws IOException {
        buf.write("\"");
        buf.write(str);
        buf.write("\"");
    }

    public void convertSymbol(Writer buf, ISymbol sym) throws IOException {
        buf.write(sym.toString());
    }

    public void convertPattern(Writer buf, IPattern sym) throws IOException {
        buf.write(sym.toString());
    }

    public void convertHead(Writer buf, IExpr obj) throws IOException {
        this.convert(buf, obj);
    }

    public void convertPlusOperator(Writer buf, IAST plusAST, InfixOperator oper, int precedence) throws IOException {
        int size;
        if (oper.getPrecedence() < precedence) {
            buf.write("(");
        }
        int i = size = plusAST.size() - 1;
        while (i > 0) {
            IExpr temp = (IExpr)plusAST.get(i);
            if (temp instanceof IAST && ((IAST)temp).size() > 1 && ((IAST)temp).topHead().toString().equals("Times")) {
                String multCh = ASTNodeFactory.MMA_STYLE_FACTORY.get("Times").getOperatorString();
                boolean flag = false;
                IAST multFun = (IAST)temp;
                Object temp1 = multFun.get(1);
                if (temp1 instanceof INumber && ((INumber)temp1).complexSign() < 0) {
                    if (((INumber)temp1).equalsInt(1)) {
                        flag = true;
                    } else if (((INumber)temp1).equalsInt(-1)) {
                        buf.write("-");
                        flag = true;
                    } else {
                        this.convertNumber(buf, (INumber)temp1, oper.getPrecedence());
                    }
                } else {
                    if (i < size) {
                        buf.write(ASTNodeFactory.MMA_STYLE_FACTORY.get("Plus").getOperatorString());
                    }
                    this.convert(buf, temp1, 3800);
                }
                int j = 2;
                while (j < multFun.size()) {
                    temp1 = multFun.get(j);
                    if (j > 2 || !flag) {
                        buf.write(multCh);
                    }
                    this.convert(buf, temp1, 3800);
                    ++j;
                }
            } else if (temp instanceof ISignedNumber && ((ISignedNumber)temp).isNegative()) {
                this.convert(buf, temp);
            } else {
                if (i < size) {
                    buf.write(ASTNodeFactory.MMA_STYLE_FACTORY.get("Plus").getOperatorString());
                }
                this.convert(buf, temp, 2900);
            }
            --i;
        }
        if (oper.getPrecedence() < precedence) {
            buf.write(")");
        }
    }

    public void convertBinaryOperator(Writer buf, IAST list, InfixOperator oper, int precedence) throws IOException {
        if (oper.getPrecedence() < precedence) {
            buf.write("(");
        }
        if (list.size() > 1) {
            this.convert(buf, list.get(1), oper.getPrecedence());
        }
        int i = 2;
        while (i < list.size()) {
            buf.write(oper.getOperatorString());
            this.convert(buf, list.get(i), oper.getPrecedence());
            ++i;
        }
        if (oper.getPrecedence() < precedence) {
            buf.write(")");
        }
    }

    public void convertPrefixOperator(Writer buf, IAST list, PrefixOperator oper, int precedence) throws IOException {
        if (oper.getPrecedence() < precedence) {
            buf.write("(");
        }
        buf.write(oper.getOperatorString());
        this.convert(buf, list.get(1), oper.getPrecedence());
        if (oper.getPrecedence() < precedence) {
            buf.write(")");
        }
    }

    public void convertPostfixOperator(Writer buf, IAST list, PostfixOperator oper, int precedence) throws IOException {
        if (oper.getPrecedence() < precedence) {
            buf.write("(");
        }
        this.convert(buf, list.get(1), oper.getPrecedence());
        buf.write(oper.getOperatorString());
        if (oper.getPrecedence() < precedence) {
            buf.write(")");
        }
    }

    public void convert(Writer buf, IExpr o) throws IOException {
        this.convert(buf, o, Integer.MIN_VALUE);
    }

    public void convertNumber(Writer buf, INumber o, int precedence) throws IOException {
        if (o instanceof INum) {
            this.convertDouble(buf, (INum)o, precedence);
            return;
        }
        if (o instanceof IComplexNum) {
            this.convertDoubleComplex(buf, (IComplexNum)o, precedence);
            return;
        }
        if (o instanceof IInteger) {
            this.convertInteger(buf, (IInteger)o, precedence);
            return;
        }
        if (o instanceof IFraction) {
            this.convertFraction(buf, ((IFraction)o).getRational(), precedence);
            return;
        }
        if (o instanceof IComplex) {
            this.convertComplex(buf, (IComplex)o, precedence);
            return;
        }
    }

    public void convert(Writer buf, Object o, int precedence) throws IOException {
        if (o instanceof IAST) {
            IAST list = (IAST)o;
            String header = list.topHead().toString();
            Map<String, Operator> map = ASTNodeFactory.MMA_STYLE_FACTORY.getIdentifier2OperatorMap();
            Operator oper = map.get(header);
            if (oper != null) {
                if (oper instanceof PrefixOperator && list.size() == 2) {
                    this.convertPrefixOperator(buf, list, (PrefixOperator)oper, precedence);
                    return;
                }
                if (oper instanceof InfixOperator && list.size() > 2) {
                    if (header.equals("Plus")) {
                        this.convertPlusOperator(buf, list, (InfixOperator)oper, precedence);
                        return;
                    }
                    this.convertBinaryOperator(buf, list, (InfixOperator)oper, precedence);
                    return;
                }
                if (oper instanceof PostfixOperator && list.size() == 2) {
                    this.convertPostfixOperator(buf, list, (PostfixOperator)oper, precedence);
                    return;
                }
            }
            if (list.isList()) {
                this.convertList(buf, list);
                return;
            }
            if (header.equals("Part") && list.size() == 3) {
                this.convertPart(buf, list);
                return;
            }
            if (header.equals("Slot") && list.size() == 2 && list.get(1) instanceof IInteger) {
                this.convertSlot(buf, list);
                return;
            }
            if (header.equals("Hold") && list.size() == 2) {
                this.convert(buf, (IExpr)list.get(1));
                return;
            }
            if (header.equals("DirectedInfinity")) {
                if (list.size() == 1) {
                    buf.write("ComplexInfinity");
                    return;
                }
                if (list.size() == 2) {
                    if (((IExpr)list.get(1)).equals(F.C1)) {
                        buf.write("Infinity");
                        return;
                    }
                    if (((IExpr)list.get(1)).equals(F.CN1)) {
                        if (2900 < precedence) {
                            buf.write("(");
                        }
                        buf.write("-Infinity");
                        if (2900 < precedence) {
                            buf.write(")");
                        }
                        return;
                    }
                }
            }
            this.convertAST(buf, list);
            return;
        }
        if (o instanceof ISignedNumber) {
            this.convertNumber(buf, (ISignedNumber)o, precedence);
            return;
        }
        if (o instanceof IComplexNum) {
            this.convertDoubleComplex(buf, (IComplexNum)o, precedence);
            return;
        }
        if (o instanceof IComplex) {
            this.convertComplex(buf, (IComplex)o, precedence);
            return;
        }
        if (o instanceof ISymbol) {
            this.convertSymbol(buf, (ISymbol)o);
            return;
        }
        if (o instanceof IPattern) {
            this.convertPattern(buf, (IPattern)o);
            return;
        }
        if (o instanceof Rational) {
            this.convertFraction(buf, (Rational)o, precedence);
        }
        this.convertString(buf, o.toString());
    }

    public void convertSlot(Writer buf, IAST list) throws IOException {
        try {
            int slot = ((IInteger)list.get(1)).toInt();
            buf.write("#" + slot);
        }
        catch (ArithmeticException arithmeticException) {
            // empty catch block
        }
    }

    public void convertList(Writer buf, IAST list) throws IOException {
        StringBufferWriter sbw;
        if (list.isEvalFlagOn(32) && buf instanceof StringBufferWriter && !(sbw = (StringBufferWriter)buf).isEmpty()) {
            sbw.newLine();
        }
        buf.write("{");
        if (list.size() > 1) {
            this.convert(buf, (IExpr)list.get(1));
        }
        int i = 2;
        while (i < list.size()) {
            buf.write(",");
            if (list.isEvalFlagOn(32)) {
                if (buf instanceof StringBufferWriter) {
                    StringBufferWriter sbw2 = (StringBufferWriter)buf;
                    sbw2.newLine();
                    sbw2.write(32);
                } else {
                    buf.write("\n ");
                }
            }
            this.convert(buf, (IExpr)list.get(i));
            ++i;
        }
        buf.write("}");
    }

    public void convertPart(Writer buf, IAST list) throws IOException {
        IExpr arg1 = (IExpr)list.get(1);
        if (!(arg1 instanceof IAST)) {
            buf.write("(");
        }
        this.convert(buf, (IExpr)list.get(1));
        if (this.fRelaxedSyntax) {
            buf.write("[");
        } else {
            buf.write("[[");
        }
        this.convert(buf, (IExpr)list.get(2));
        if (this.fRelaxedSyntax) {
            buf.write("]");
        } else {
            buf.write("]]");
        }
        if (!(arg1 instanceof IAST)) {
            buf.write(")");
        }
    }

    public void convertAST(Writer buf, IAST function) throws IOException {
        this.convert(buf, function.head());
        if (this.fRelaxedSyntax) {
            buf.write("(");
        } else {
            buf.write("[");
        }
        if (function.size() > 1) {
            this.convert(buf, (IExpr)function.get(1));
        }
        int i = 2;
        while (i < function.size()) {
            buf.write(",");
            this.convert(buf, (IExpr)function.get(i));
            ++i;
        }
        if (this.fRelaxedSyntax) {
            buf.write(")");
        } else {
            buf.write("]");
        }
    }
}

