/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.form.output;

import java.io.IOException;
import java.io.Writer;

public class StringBufferWriter
extends Writer {
    private boolean fIgnoreNewLine = false;
    private StringBuilder fBuffer;
    private int fColumnCounter;

    public StringBufferWriter() {
        this(16);
    }

    public StringBufferWriter(int initialSize) {
        if (initialSize < 0) {
            throw new IllegalArgumentException("Negative buffer size");
        }
        this.fBuffer = new StringBuilder(initialSize);
        this.lock = this.fBuffer;
    }

    public StringBufferWriter(StringBuilder buffer) {
        this.fBuffer = buffer;
        this.lock = buffer;
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public void flush() {
    }

    public StringBuilder getBuffer() {
        return this.fBuffer;
    }

    public int getColumnCounter() {
        return this.fColumnCounter;
    }

    public void newLine() {
        if (!this.fIgnoreNewLine) {
            this.fBuffer.append('\n');
        }
        this.fColumnCounter = 0;
    }

    public void setColumnCounter(int columnCounter) {
        this.fColumnCounter = columnCounter;
    }

    public String toString() {
        return this.fBuffer.toString();
    }

    @Override
    public void write(char[] cbuf, int off, int len) {
        if (off < 0 || off > cbuf.length || len < 0 || off + len > cbuf.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return;
        }
        this.fBuffer.append(cbuf, off, len);
        this.fColumnCounter += len;
    }

    @Override
    public void write(int c) {
        this.fBuffer.append((char)c);
        ++this.fColumnCounter;
    }

    @Override
    public void write(String str) {
        this.fBuffer.append(str);
        this.fColumnCounter += str.length();
    }

    @Override
    public void write(String str, int off, int len) {
        this.fBuffer.append(str.substring(off, off + len));
        this.fColumnCounter += len;
    }

    public boolean isIgnoreNewLine() {
        return this.fIgnoreNewLine;
    }

    public boolean isEmpty() {
        return this.fBuffer.length() == 0;
    }

    public void setIgnoreNewLine(boolean ignoreNewLine) {
        this.fIgnoreNewLine = ignoreNewLine;
    }

    protected Object clone() throws CloneNotSupportedException {
        StringBufferWriter writer = (StringBufferWriter)super.clone();
        writer.fBuffer = new StringBuilder();
        writer.lock = this.fBuffer;
        writer.fIgnoreNewLine = this.fIgnoreNewLine;
        return writer;
    }
}

