/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.form.tex;

import org.matheclipse.core.form.tex.AbstractConverter;
import org.matheclipse.core.interfaces.IAST;

public abstract class AbstractOperator
extends AbstractConverter {
    protected int fPrecedence;
    protected String fOperator;

    public AbstractOperator(int precedence, String oper) {
        this.fPrecedence = precedence;
        this.fOperator = oper;
    }

    public void precedenceOpen(StringBuffer buf, int precedence) {
        if (precedence > this.fPrecedence) {
            buf.append("\\left( ");
        }
    }

    public void precedenceClose(StringBuffer buf, int precedence) {
        if (precedence > this.fPrecedence) {
            buf.append("\\right) ");
        }
    }

    @Override
    public boolean convert(StringBuffer buf, IAST f, int precedence) {
        this.precedenceOpen(buf, precedence);
        int i = 1;
        while (i < f.size()) {
            this.fFactory.convert(buf, f.get(i), this.fPrecedence);
            if (i < f.size() - 1 && this.fOperator.compareTo("") != 0) {
                buf.append(this.fOperator);
            }
            ++i;
        }
        this.precedenceClose(buf, precedence);
        return true;
    }
}

