/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.form.tex;

import java.util.Hashtable;
import org.matheclipse.core.expression.IConstantHeaders;
import org.matheclipse.core.form.tex.AbstractConverter;
import org.matheclipse.core.form.tex.AbstractTeXFormFactory;
import org.matheclipse.core.form.tex.IConverter;
import org.matheclipse.core.form.tex.TeXFunction;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IComplex;
import org.matheclipse.core.interfaces.IComplexNum;
import org.matheclipse.core.interfaces.IFraction;
import org.matheclipse.core.interfaces.IInteger;
import org.matheclipse.core.interfaces.INum;
import org.matheclipse.core.interfaces.ISymbol;
import org.matheclipse.parser.client.operator.ASTNodeFactory;

public class TeXFormFactory
extends AbstractTeXFormFactory
implements IConstantHeaders {
    public final Hashtable<String, Object> CONSTANT_SYMBOLS = new Hashtable(199);
    public final Hashtable<String, AbstractConverter> operTab = new Hashtable(199);
    private int plusPrec;

    public TeXFormFactory() {
        this("");
    }

    public TeXFormFactory(String tagPrefix) {
        this.init();
    }

    @Override
    public void convertDouble(StringBuffer buf, INum d, int precedence) {
        if (d.isNegative() && precedence > this.plusPrec) {
            buf.append("\\left( ");
        }
        buf.append(d.toString());
        if (d.isNegative() && precedence > this.plusPrec) {
            buf.append("\\right) ");
        }
    }

    @Override
    public void convertDoubleComplex(StringBuffer buf, IComplexNum dc, int precedence) {
        if (precedence > this.plusPrec) {
            buf.append("\\left( ");
        }
        this.convert(buf, dc.getRealPart(), 0);
        buf.append(" + ");
        this.convert(buf, dc.getImaginaryPart(), 0);
        buf.append("\\,");
        buf.append("\\imag");
        if (precedence > this.plusPrec) {
            buf.append("\\right) ");
        }
    }

    @Override
    public void convertInteger(StringBuffer buf, IInteger i, int precedence) {
        if (i.isNegative() && precedence > this.plusPrec) {
            buf.append("\\left( ");
        }
        buf.append(i.getBigNumerator().toString());
        if (i.isNegative() && precedence > this.plusPrec) {
            buf.append("\\right) ");
        }
    }

    @Override
    public void convertFraction(StringBuffer buf, IFraction f, int precedence) {
        if (f.isNegative() && precedence > this.plusPrec) {
            buf.append("\\left( ");
        }
        buf.append("\\frac{");
        buf.append(f.getBigNumerator().toString());
        buf.append("}{");
        buf.append(f.getBigDenominator().toString());
        buf.append('}');
        if (f.isNegative() && precedence > this.plusPrec) {
            buf.append("\\right) ");
        }
    }

    @Override
    public void convertComplex(StringBuffer buf, IComplex c, int precedence) {
        if (precedence > this.plusPrec) {
            buf.append("\\left( ");
        }
        this.convert(buf, c.getRealPart(), 0);
        buf.append(" + ");
        this.convert(buf, c.getImaginaryPart(), 0);
        buf.append("\\,");
        buf.append("\\imag");
        if (precedence > this.plusPrec) {
            buf.append("\\right) ");
        }
    }

    @Override
    public void convertString(StringBuffer buf, String str) {
        buf.append(str);
    }

    @Override
    public void convertSymbol(StringBuffer buf, ISymbol sym) {
        Object convertedSymbol = this.CONSTANT_SYMBOLS.get(sym.toString());
        if (convertedSymbol == null) {
            buf.append(sym.toString());
        } else if (convertedSymbol.equals("True")) {
            buf.append('\\');
            buf.append(sym.toString());
        } else if (convertedSymbol instanceof Operator) {
            ((Operator)convertedSymbol).convert(buf);
        } else {
            buf.append(convertedSymbol.toString());
        }
    }

    @Override
    public void convertHead(StringBuffer buf, Object obj) {
        if (obj instanceof ISymbol) {
            Object ho = this.CONSTANT_SYMBOLS.get(((ISymbol)obj).toString());
            if (ho != null && ho.equals("True")) {
                buf.append('\\');
            }
            buf.append(((ISymbol)obj).toString());
            return;
        }
        this.convert(buf, obj, 0);
    }

    @Override
    public void convert(StringBuffer buf, Object o, int precedence) {
        if (o instanceof IAST) {
            IAST f = (IAST)o;
            IConverter converter = this.reflection(f.head().toString());
            if (converter == null || !converter.convert(buf, f, precedence)) {
                this.convertAST(buf, f);
            }
            return;
        }
        if (o instanceof INum) {
            this.convertDouble(buf, (INum)o, precedence);
            return;
        }
        if (o instanceof IComplexNum) {
            this.convertDoubleComplex(buf, (IComplexNum)o, precedence);
            return;
        }
        if (o instanceof IInteger) {
            this.convertInteger(buf, (IInteger)o, precedence);
            return;
        }
        if (o instanceof IFraction) {
            this.convertFraction(buf, (IFraction)o, precedence);
            return;
        }
        if (o instanceof IComplex) {
            this.convertComplex(buf, (IComplex)o, precedence);
            return;
        }
        if (o instanceof ISymbol) {
            this.convertSymbol(buf, (ISymbol)o);
            return;
        }
        this.convertString(buf, o.toString());
    }

    private void convertAST(StringBuffer buf, IAST f) {
        this.convertHead(buf, f.head());
        buf.append('(');
        int i = 1;
        while (i < f.size()) {
            this.convert(buf, f.get(i), 0);
            if (i < f.size() - 1) {
                buf.append(',');
            }
            ++i;
        }
        buf.append(')');
    }

    @Override
    public String getReflectionNamespace() {
        return "org.matheclipse.core.form.tex.reflection.";
    }

    @Override
    public IConverter reflection(String headString) {
        IConverter converter = this.operTab.get(headString);
        if (converter != null) {
            return converter;
        }
        String namespace = String.valueOf(this.getReflectionNamespace()) + headString;
        Class<?> clazz = null;
        try {
            clazz = Class.forName(namespace);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
        try {
            AbstractConverter module = (AbstractConverter)clazz.newInstance();
            module.setFactory(this);
            this.operTab.put(headString, module);
            return module;
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public void init() {
        this.plusPrec = ASTNodeFactory.MMA_STYLE_FACTORY.get("Plus").getPrecedence();
        this.operTab.put("Sin", new TeXFunction(this, "sin"));
        this.operTab.put("Cos", new TeXFunction(this, "cos"));
        this.operTab.put("Tan", new TeXFunction(this, "tan"));
        this.operTab.put("Cot", new TeXFunction(this, "cot"));
        this.operTab.put("ArcSin", new TeXFunction(this, "arcsin"));
        this.operTab.put("ArcCos", new TeXFunction(this, "arccos"));
        this.operTab.put("ArcTan", new TeXFunction(this, "arctan"));
        this.operTab.put("ArcCot", new TeXFunction(this, "arccot"));
        this.operTab.put("ArcSinh", new TeXFunction(this, "arcsinh"));
        this.operTab.put("ArcCosh", new TeXFunction(this, "arccosh"));
        this.operTab.put("ArcTanh", new TeXFunction(this, "arctanh"));
        this.operTab.put("ArcCoth", new TeXFunction(this, "arccoth"));
        this.operTab.put("Log", new TeXFunction(this, "log"));
        this.CONSTANT_SYMBOLS.put("Pi", "\\pi");
        this.CONSTANT_SYMBOLS.put("Alpha", "True");
        this.CONSTANT_SYMBOLS.put("Beta", "True");
        this.CONSTANT_SYMBOLS.put("Chi", "True");
        this.CONSTANT_SYMBOLS.put("Delta", "True");
        this.CONSTANT_SYMBOLS.put("Epsilon", "True");
        this.CONSTANT_SYMBOLS.put("Phi", "True");
        this.CONSTANT_SYMBOLS.put("Gamma", "True");
        this.CONSTANT_SYMBOLS.put("Eta", "True");
        this.CONSTANT_SYMBOLS.put("Iota", "True");
        this.CONSTANT_SYMBOLS.put("varTheta", "True");
        this.CONSTANT_SYMBOLS.put("Kappa", "True");
        this.CONSTANT_SYMBOLS.put("Lambda", "True");
        this.CONSTANT_SYMBOLS.put("Mu", "True");
        this.CONSTANT_SYMBOLS.put("Nu", "True");
        this.CONSTANT_SYMBOLS.put("Omicron", "True");
        this.CONSTANT_SYMBOLS.put("Theta", "True");
        this.CONSTANT_SYMBOLS.put("Rho", "True");
        this.CONSTANT_SYMBOLS.put("Sigma", "True");
        this.CONSTANT_SYMBOLS.put("Tau", "True");
        this.CONSTANT_SYMBOLS.put("Upsilon", "True");
        this.CONSTANT_SYMBOLS.put("Omega", "True");
        this.CONSTANT_SYMBOLS.put("Xi", "True");
        this.CONSTANT_SYMBOLS.put("Psi", "True");
        this.CONSTANT_SYMBOLS.put("Zeta", "True");
        this.CONSTANT_SYMBOLS.put("alpha", "True");
        this.CONSTANT_SYMBOLS.put("beta", "True");
        this.CONSTANT_SYMBOLS.put("chi", "True");
        this.CONSTANT_SYMBOLS.put("selta", "True");
        this.CONSTANT_SYMBOLS.put("epsilon", "True");
        this.CONSTANT_SYMBOLS.put("phi", "True");
        this.CONSTANT_SYMBOLS.put("gamma", "True");
        this.CONSTANT_SYMBOLS.put("eta", "True");
        this.CONSTANT_SYMBOLS.put("iota", "True");
        this.CONSTANT_SYMBOLS.put("varphi", "True");
        this.CONSTANT_SYMBOLS.put("kappa", "True");
        this.CONSTANT_SYMBOLS.put("lambda", "True");
        this.CONSTANT_SYMBOLS.put("mu", "True");
        this.CONSTANT_SYMBOLS.put("nu", "True");
        this.CONSTANT_SYMBOLS.put("omicron", "True");
        this.CONSTANT_SYMBOLS.put("theta", "True");
        this.CONSTANT_SYMBOLS.put("rho", "True");
        this.CONSTANT_SYMBOLS.put("sigma", "True");
        this.CONSTANT_SYMBOLS.put("tau", "True");
        this.CONSTANT_SYMBOLS.put("upsilon", "True");
        this.CONSTANT_SYMBOLS.put("varomega", "True");
        this.CONSTANT_SYMBOLS.put("omega", "True");
        this.CONSTANT_SYMBOLS.put("xi", "True");
        this.CONSTANT_SYMBOLS.put("psi", "True");
        this.CONSTANT_SYMBOLS.put("zeta", "True");
    }

    static class Operator {
        String fOperator;

        Operator(String oper) {
            this.fOperator = oper;
        }

        public void convert(StringBuffer buf) {
            buf.append(this.fOperator);
        }

        public String toString() {
            return this.fOperator;
        }
    }
}

