/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.generic;

import org.matheclipse.basic.Alloc;
import org.matheclipse.core.eval.EvalDouble;
import org.matheclipse.core.expression.AST;
import org.matheclipse.core.expression.ComplexNum;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.expression.Num;
import org.matheclipse.core.generic.BinaryFunctorImpl;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.ISymbol;

public class BinaryNumerical
extends BinaryFunctorImpl<IExpr> {
    IExpr fun;
    ISymbol variable1;
    ISymbol variable2;

    public BinaryNumerical(IExpr fn, ISymbol v1, ISymbol v2) {
        this.variable1 = v1;
        this.variable2 = v2;
        this.fun = fn;
    }

    @Override
    public IExpr apply(IExpr firstArg, IExpr secondArg) {
        IExpr temp = AST.COPY.substitute(this.fun, this.variable1, firstArg, 1);
        return F.evaln(AST.COPY.substitute(temp, this.variable2, secondArg, 1));
    }

    public double value(double x, double y) {
        double result = 0.0;
        try {
            this.variable1.pushLocalVariable(Num.valueOf(x));
            this.variable2.pushLocalVariable(Num.valueOf(y));
            Alloc alloc = Alloc.get();
            double[] stack = alloc.vector(10);
            result = EvalDouble.eval(stack, 0, this.fun);
            alloc.freeVector(10);
        }
        finally {
            this.variable2.popLocalVariable();
            this.variable1.popLocalVariable();
        }
        return result;
    }

    public ComplexNum value(ComplexNum z1, ComplexNum z2) {
        IExpr temp = this.apply(z1, z2);
        if (temp instanceof ComplexNum) {
            return (ComplexNum)temp;
        }
        if (temp instanceof Num) {
            return ComplexNum.valueOf(((Num)temp).getRealPart());
        }
        throw new ArithmeticException("Numerical complex value expected");
    }
}

