/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.generic;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import org.matheclipse.core.convert.AST2Expr;
import org.matheclipse.core.eval.EvalEngine;
import org.matheclipse.core.eval.exception.WrongArgumentType;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.IPattern;
import org.matheclipse.core.patternmatching.PatternMatcherAndEvaluator;
import org.matheclipse.parser.client.Parser;
import org.matheclipse.parser.client.ast.ASTNode;

public class Functors {
    public static Function<IExpr, IExpr> append(@Nonnull IAST ast) {
        return new AppendFunctor(ast);
    }

    public static Function<IExpr, IExpr> constant(@Nonnull IExpr expr) {
        return new ConstantFunctor(expr);
    }

    public static Function<IExpr, IExpr> replace1st(@Nonnull IAST ast) {
        return new ReplaceArgFunctor(ast, 1);
    }

    public static Function<IExpr, IExpr> replace2nd(@Nonnull IAST ast) {
        return new ReplaceArgFunctor(ast, 2);
    }

    public static Function<IExpr, IExpr> replaceArg(@Nonnull IAST ast, int position) {
        return new ReplaceArgFunctor(ast, position);
    }

    public static Function<IExpr, IExpr> rules(Map<? extends IExpr, ? extends IExpr> rulesMap) {
        return new RulesFunctor(rulesMap);
    }

    public static Function<IExpr, IExpr> rules(@Nonnull String[] strRules) throws WrongArgumentType {
        IAST astRules = F.List();
        Parser parser = new Parser();
        EvalEngine engine = EvalEngine.get();
        String[] stringArray = strRules;
        int n = strRules.length;
        int n2 = 0;
        while (n2 < n) {
            String str = stringArray[n2];
            ASTNode parsedAST = parser.parse(str);
            IExpr expr = AST2Expr.CONST.convert(parsedAST);
            expr = engine.evaluate(expr);
            astRules.add(expr);
            ++n2;
        }
        return Functors.rules(astRules);
    }

    public static Function<IExpr, IExpr> rules(@Nonnull IAST astRules) throws WrongArgumentType {
        HashMap<IExpr, IExpr> equalRules = new HashMap<IExpr, IExpr>();
        ArrayList<PatternMatcherAndEvaluator> matchers = new ArrayList<PatternMatcherAndEvaluator>();
        Predicate<IExpr> patternQ = new Predicate<IExpr>(){

            public boolean apply(IExpr input) {
                return input instanceof IPattern;
            }
        };
        if (astRules.isList()) {
            for (IExpr expr : astRules) {
                if (expr.isRuleAST()) {
                    IAST rule = (IAST)expr;
                    if (((IExpr)rule.get(1)).isFree(patternQ)) {
                        equalRules.put((IExpr)rule.get(1), (IExpr)rule.get(2));
                        continue;
                    }
                    matchers.add(new PatternMatcherAndEvaluator(F.SetDelayed, (IExpr)rule.get(1), (IExpr)rule.get(2)));
                    continue;
                }
                throw new WrongArgumentType(astRules, astRules, -1, "Rule expression (x->y) expected: ");
            }
        } else if (astRules.isRuleAST()) {
            if (((IExpr)astRules.get(1)).isFree(patternQ)) {
                equalRules.put((IExpr)astRules.get(1), (IExpr)astRules.get(2));
            } else {
                matchers.add(new PatternMatcherAndEvaluator(F.SetDelayed, (IExpr)astRules.get(1), (IExpr)astRules.get(2)));
            }
        } else {
            throw new WrongArgumentType(astRules, astRules, -1, "Rule expression (x->y) expected: ");
        }
        if (matchers.size() > 0) {
            return new RulesPatternFunctor(equalRules, matchers);
        }
        return Functors.rules(equalRules);
    }

    private Functors() {
    }

    private static class AppendFunctor
    implements Function<IExpr, IExpr> {
        protected final IAST fAST;

        public AppendFunctor(IAST ast) {
            this.fAST = ast;
        }

        public IExpr apply(IExpr arg) {
            IAST ast = this.fAST.clone();
            ast.add(arg);
            return ast;
        }
    }

    private static class ConstantFunctor
    implements Function<IExpr, IExpr> {
        final IExpr fConstant;

        public ConstantFunctor(IExpr expr) {
            this.fConstant = expr;
        }

        public IExpr apply(IExpr arg) {
            return this.fConstant;
        }
    }

    private static class ReplaceArgFunctor
    implements Function<IExpr, IExpr> {
        private final IAST fConstant;
        private final int fPosition;

        public ReplaceArgFunctor(IAST ast, int position) {
            this.fConstant = ast;
            this.fPosition = position;
        }

        public IExpr apply(IExpr arg) {
            IAST ast = this.fConstant.clone();
            ast.set(this.fPosition, arg);
            return ast;
        }
    }

    private static class RulesFunctor
    implements Function<IExpr, IExpr> {
        private final Map<? extends IExpr, ? extends IExpr> fEqualRules;

        public RulesFunctor(Map<? extends IExpr, ? extends IExpr> rulesMap) {
            this.fEqualRules = rulesMap;
        }

        public IExpr apply(IExpr arg) {
            return this.fEqualRules.get(arg);
        }
    }

    private static class RulesPatternFunctor
    implements Function<IExpr, IExpr> {
        private final Map<IExpr, IExpr> fEqualRules;
        private final List<PatternMatcherAndEvaluator> fMatchers;

        public RulesPatternFunctor(Map<IExpr, IExpr> equalRules, List<PatternMatcherAndEvaluator> matchers) {
            this.fEqualRules = equalRules;
            this.fMatchers = matchers;
        }

        public IExpr apply(IExpr arg) {
            IExpr temp = this.fEqualRules.get(arg);
            if (temp != null) {
                return temp;
            }
            int i = 0;
            while (i < this.fMatchers.size()) {
                temp = this.fMatchers.get(i).eval(arg);
                if (temp != null) {
                    return temp;
                }
                ++i;
            }
            return null;
        }
    }
}

