/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.generic;

import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.IInteger;
import org.matheclipse.generic.nested.LevelSpec;

public class LevelSpecification
extends LevelSpec {
    public LevelSpecification() {
        this.fToLevel = Integer.MAX_VALUE;
        this.fFromDepth = Integer.MIN_VALUE;
        this.fToDepth = -1;
    }

    public LevelSpecification(IExpr obj) {
        this.fToLevel = -1;
        this.fFromLevel = -1;
        this.fToDepth = 0;
        this.fFromDepth = 0;
        if (obj instanceof IInteger) {
            IInteger value = (IInteger)obj;
            if (value.isNegative()) {
                this.fFromDepth = Integer.MIN_VALUE;
                this.fToDepth = value.getBigNumerator().intValue();
                this.fFromLevel = 0;
                this.fToLevel = Integer.MAX_VALUE;
            } else {
                this.fToLevel = value.getBigNumerator().intValue();
                this.fFromLevel = 0;
                this.fFromDepth = Integer.MIN_VALUE;
                this.fToDepth = -1;
            }
            return;
        }
        if (obj.isList()) {
            IAST lst = (IAST)obj;
            if (lst.size() == 2) {
                if (lst.get(1) instanceof IInteger) {
                    IInteger i = (IInteger)lst.get(1);
                    if (i.isNegative()) {
                        this.fFromDepth = i.getBigNumerator().intValue();
                        this.fToDepth = i.getBigNumerator().intValue();
                        this.fFromLevel = 0;
                        this.fToLevel = Integer.MAX_VALUE;
                        if (this.fToDepth < this.fFromDepth) {
                            throw new Error("Error in LevelSpecification 1");
                        }
                    } else {
                        this.fToLevel = i.getBigNumerator().intValue();
                        this.fFromLevel = i.getBigNumerator().intValue();
                        this.fFromDepth = Integer.MIN_VALUE;
                        this.fToDepth = -1;
                        if (this.fToLevel < this.fFromLevel) {
                            throw new Error("Error in LevelSpecification 2");
                        }
                    }
                    return;
                }
            } else if (lst.size() == 3 && lst.get(1) instanceof IInteger && lst.get(2) instanceof IInteger) {
                IInteger i0 = (IInteger)lst.get(1);
                IInteger i1 = (IInteger)lst.get(2);
                if (i0.isNegative() && i1.isNegative()) {
                    this.fFromDepth = i0.getBigNumerator().intValue();
                    this.fToDepth = i1.getBigNumerator().intValue();
                    this.fFromLevel = 0;
                    this.fToLevel = Integer.MAX_VALUE;
                } else {
                    if (i0.isNegative()) {
                        throw new Error("Invalid Level specification!");
                    }
                    if (i1.isNegative()) {
                        this.fFromDepth = Integer.MIN_VALUE;
                        this.fToDepth = i1.getBigNumerator().intValue();
                        this.fFromLevel = i0.getBigNumerator().intValue();
                        this.fToLevel = Integer.MAX_VALUE;
                    } else {
                        this.fFromDepth = Integer.MIN_VALUE;
                        this.fToDepth = -1;
                        this.fFromLevel = i0.getBigNumerator().intValue();
                        this.fToLevel = i1.getBigNumerator().intValue();
                    }
                }
                return;
            }
        }
        throw new Error("Invalid Level specification!");
    }

    public LevelSpecification(int level) {
        this(level, level);
    }

    public LevelSpecification(int levelFrom, int levelTo) {
        this.fFromLevel = levelFrom;
        this.fToLevel = levelTo;
        this.fFromDepth = Integer.MIN_VALUE;
        this.fToDepth = -1;
    }

    public int getFrom() {
        return this.fFromLevel;
    }

    public int getTo() {
        return this.fToLevel;
    }

    public final boolean includesDepth(int i) {
        return this.fFromDepth <= (i *= -1) && this.fToDepth >= i;
    }

    public final boolean includesLevel(int i) {
        return this.fFromLevel <= i && this.fToLevel >= i;
    }

    public final int compareDepth(int i) {
        if (this.fFromDepth > (i *= -1)) {
            return -1;
        }
        if (this.fToDepth < i) {
            return 1;
        }
        return 0;
    }

    public final int compareLevel() {
        return this.compareLevel(this.fCurrentLevel);
    }

    public final int compareLevel(int i) {
        if (this.fFromLevel > i) {
            return -1;
        }
        if (this.fToLevel < i) {
            return 1;
        }
        return 0;
    }

    public void setFrom(int i) {
        this.fFromLevel = i;
    }

    public void setTo(int i) {
        this.fToLevel = i;
    }
}

