/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.generic;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import java.io.Serializable;
import javax.annotation.Nullable;
import org.matheclipse.core.eval.EvalEngine;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IExpr;

public class Predicates {
    private Predicates() {
    }

    public static Predicate<IExpr> isTrue(IExpr head) {
        return new IsUnaryTrue<IExpr>(head);
    }

    public static Predicate<IExpr> isTrue(EvalEngine engine, IExpr head) {
        return new IsUnaryTrue<IExpr>(engine, head);
    }

    public static Predicate<IExpr> in(IAST target) {
        return new InASTPredicate(target);
    }

    private static class InASTPredicate
    implements Predicate<IExpr>,
    Serializable {
        private final IAST target;
        private static final long serialVersionUID = 0L;

        private InASTPredicate(IAST target) {
            this.target = (IAST)Preconditions.checkNotNull((Object)target);
        }

        public boolean apply(IExpr t) {
            for (IExpr expr : this.target) {
                if (!expr.equals(t)) continue;
                return true;
            }
            return false;
        }

        public boolean equals(@Nullable Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof InASTPredicate) {
                InASTPredicate that = (InASTPredicate)obj;
                return this.target.equals(that.target);
            }
            return false;
        }

        public int hashCode() {
            return this.target.hashCode();
        }

        public String toString() {
            return "In(" + this.target + ")";
        }
    }

    private static class IsUnaryTrue<E extends IExpr>
    implements Predicate<E> {
        protected final EvalEngine fEngine = EvalEngine.get();
        protected final IAST fAST;

        public IsUnaryTrue(IExpr head) {
            this(EvalEngine.get(), head);
        }

        public IsUnaryTrue(EvalEngine engine, IExpr head) {
            this.fAST = F.ast(head, 1, false);
        }

        public boolean apply(IExpr arg) {
            IAST ast = this.fAST.clone();
            ast.add(arg);
            return this.fEngine.evaluate(ast).equals(F.True);
        }
    }
}

