/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.generic;

import com.google.common.base.Function;
import org.apache.commons.math.analysis.DifferentiableUnivariateRealFunction;
import org.apache.commons.math.analysis.UnivariateRealFunction;
import org.matheclipse.basic.Alloc;
import org.matheclipse.core.eval.EvalDouble;
import org.matheclipse.core.eval.EvalEngine;
import org.matheclipse.core.expression.AST;
import org.matheclipse.core.expression.ComplexNum;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.expression.Num;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.INum;
import org.matheclipse.core.interfaces.ISymbol;

public class UnaryNumerical
implements Function<IExpr, IExpr>,
DifferentiableUnivariateRealFunction {
    IExpr fFunction;
    ISymbol fVariable;
    EvalEngine fEngine;

    public UnaryNumerical(IExpr fn, ISymbol v, EvalEngine engine) {
        this.fVariable = v;
        this.fFunction = fn;
        this.fEngine = engine;
    }

    public IExpr apply(IExpr firstArg) {
        return F.evaln(AST.COPY.substitute(this.fFunction, this.fVariable, firstArg, 1));
    }

    @Override
    public double value(double x) {
        double result = 0.0;
        Alloc alloc = Alloc.get();
        double[] stack = alloc.vector(10);
        try {
            this.fVariable.pushLocalVariable(Num.valueOf(x));
            result = EvalDouble.eval(stack, 0, this.fFunction);
        }
        finally {
            this.fVariable.popLocalVariable();
            alloc.freeVector(10);
        }
        return result;
    }

    @Override
    public UnivariateRealFunction derivative() {
        IExpr expr = F.eval(F.D, this.fFunction, this.fVariable);
        return new UnaryNumerical(expr, this.fVariable, this.fEngine);
    }

    public ComplexNum value(ComplexNum z) {
        IExpr temp = this.apply(z);
        if (temp instanceof ComplexNum) {
            return (ComplexNum)temp;
        }
        if (temp instanceof INum) {
            return ComplexNum.valueOf((INum)temp);
        }
        throw new ArithmeticException("Expected numerical complex value object!");
    }

    public INum value(INum z) {
        IExpr temp = this.apply(z);
        if (temp instanceof INum) {
            return (INum)temp;
        }
        throw new ArithmeticException("Expected numerical double value object!");
    }
}

