/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.generic.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import org.matheclipse.core.generic.util.INestedList;
import org.matheclipse.core.generic.util.INestedListElement;

public class NestedFastTable<E extends INestedListElement>
extends ArrayList<E>
implements INestedList<E> {
    private static final long serialVersionUID = -8300867641898160542L;
    protected static final boolean DEBUG_HASH = true;
    protected int fHash = 0;

    protected NestedFastTable(int initialCapacity, int setLength) {
        super(initialCapacity);
        int i = 0;
        while (i < setLength) {
            this.add(null);
            ++i;
        }
    }

    public NestedFastTable() {
        this(null);
    }

    public NestedFastTable(E head) {
        super(5);
        this.add(head);
    }

    public NestedFastTable(int initialCapacity) {
        super(initialCapacity);
        this.add(null);
    }

    public NestedFastTable(Collection<E> c) {
        super(c.size() + 1);
        this.add(null);
        this.addAll(c);
    }

    public NestedFastTable(Collection<E> c, E head) {
        super(c.size() + 1);
        this.add(head);
        this.addAll(c);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof NestedFastTable) {
            if (this.hashCode() != obj.hashCode()) {
                return false;
            }
            if (this.size() != ((NestedFastTable)obj).size()) {
                return false;
            }
            return super.equals(obj);
        }
        return false;
    }

    @Override
    public int hashCode() {
        if (this.fHash == 0) {
            this.fHash = this.size() >= 1 ? (this.size() == 1 ? 17 * ((INestedListElement)this.get(0)).hashCode() : 31 * ((INestedListElement)this.get(0)).hashCode() + ((INestedListElement)this.get(1)).hashCode() + this.size()) : 41;
        }
        return this.fHash;
    }

    @Override
    public Object clone() {
        NestedFastTable v = (NestedFastTable)super.clone();
        v.fHash = 0;
        return v;
    }

    public final E head() {
        return (E)((INestedListElement)this.get(0));
    }

    public final void setHeader(E head) {
        this.set(0, head);
    }

    @Override
    public String toString() {
        String sep = ", ";
        E temp = this.head();
        StringBuffer text = temp == null ? new StringBuffer("<null-tag>") : new StringBuffer(temp.toString());
        text.append('[');
        int i = 1;
        while (i < this.size()) {
            INestedListElement o = (INestedListElement)this.get(i);
            text = text.append(o == this ? "(this NestedList)" : o.toString());
            if (i < this.size() - 1) {
                text.append(", ");
            }
            ++i;
        }
        text.append(']');
        return text.toString();
    }

    @Override
    public Iterator<E> iterator() {
        FastTableIterator i = new FastTableIterator();
        i._table = this;
        i._start = 1;
        i._end = this.size();
        i._nextIndex = 1;
        i._currentIndex = 0;
        return i;
    }

    public Iterator<E> iterator0() {
        return super.iterator();
    }

    protected static final class FastTableIterator
    implements ListIterator {
        private ArrayList _table;
        private int _currentIndex;
        private int _start;
        private int _end;
        private int _nextIndex;

        protected FastTableIterator() {
        }

        @Override
        public boolean hasNext() {
            return this._nextIndex != this._end;
        }

        @Override
        public Object next() {
            if (this._nextIndex == this._end) {
                throw new NoSuchElementException();
            }
            this._currentIndex = this._nextIndex++;
            return this._table.get(this._currentIndex);
        }

        @Override
        public int nextIndex() {
            return this._nextIndex;
        }

        @Override
        public boolean hasPrevious() {
            return this._nextIndex != this._start;
        }

        public Object previous() {
            if (this._nextIndex == this._start) {
                throw new NoSuchElementException();
            }
            this._currentIndex = --this._nextIndex;
            return this._table.get(this._nextIndex);
        }

        @Override
        public int previousIndex() {
            return this._nextIndex - 1;
        }

        public void add(Object o) {
            this._table.add(this._nextIndex++, o);
            ++this._end;
            this._currentIndex = -1;
        }

        public void set(Object o) {
            if (this._currentIndex < 0) {
                throw new IllegalStateException();
            }
            this._table.set(this._currentIndex, o);
        }

        @Override
        public void remove() {
            if (this._currentIndex >= 0) {
                this._table.remove(this._currentIndex);
                --this._end;
                if (this._currentIndex < this._nextIndex) {
                    --this._nextIndex;
                }
            } else {
                throw new IllegalStateException();
            }
            this._currentIndex = -1;
        }
    }
}

