/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.list.algorithms;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import org.matheclipse.core.expression.AST;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.generic.ExprComparator;
import org.matheclipse.core.generic.Functors;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IExpr;

public class EvaluationSupport {
    public static IAST flatten(IAST ast) {
        if ((ast.getEvalFlags() & 0x100) == 256) {
            return null;
        }
        IAST res = F.ast(ast.head());
        if (AST.COPY.flatten(ast.head(), ast, res, 1)) {
            res.setEvalFlags(256);
            return res;
        }
        return null;
    }

    public static final void sort(IAST ast) {
        if ((ast.getEvalFlags() & 0x200) == 512) {
            return;
        }
        if (ast.size() > 2) {
            if (ast.size() == 3) {
                if (((IExpr)ast.get(1)).compareTo((IExpr)ast.get(2)) > 0) {
                    IExpr temp = (IExpr)ast.get(2);
                    ast.set(2, (IExpr)ast.get(1));
                    ast.set(1, temp);
                }
            } else {
                ast.args().sort(ExprComparator.CONS);
            }
        }
        ast.setEvalFlags(512);
    }

    public static final void sort(IAST list, Comparator<IExpr> comparator) {
        list.args().sort(comparator);
    }

    public static IAST threadList(IAST list, int listLength, int headOffset) {
        IAST res0 = F.ast(F.List, listLength, true);
        int j = headOffset;
        while (j < listLength + headOffset) {
            IAST res1 = F.ast(list.head(), list.size() - headOffset, true);
            int i = headOffset;
            while (i < list.size()) {
                if (list.get(i) instanceof IAST && ((IAST)list.get(i)).head().equals(F.List)) {
                    IAST arg = (IAST)list.get(i);
                    res1.set(i, (IExpr)arg.get(j));
                } else {
                    res1.set(i, (IExpr)list.get(i));
                }
                ++i;
            }
            res0.set(j, res1);
            ++j;
        }
        return res0;
    }

    public static <T extends IExpr> IExpr substituteLocalVariables(IExpr expression, ArrayList<T> symbolList, IExpr[] valueList) {
        HashMap<IExpr, IExpr> rulesMap = new HashMap<IExpr, IExpr>();
        int i = 0;
        while (i < symbolList.size()) {
            rulesMap.put((IExpr)symbolList.get(i), valueList[i]);
            ++i;
        }
        IExpr result = expression.replaceAll(Functors.rules(rulesMap));
        return result == null ? expression : result;
    }
}

