/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.patternmatching;

import com.google.common.collect.ArrayListMultimap;
import java.util.List;
import org.matheclipse.core.convert.AST2Expr;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.patternmatching.HashedPatternRules;
import org.matheclipse.core.patternmatching.RulesData;
import org.matheclipse.core.visit.HashValueVisitor;
import org.matheclipse.parser.client.Parser;
import org.matheclipse.parser.client.SyntaxError;
import org.matheclipse.parser.client.ast.ASTNode;

public class HashedOrderlessMatcher {
    ArrayListMultimap<Integer, HashedPatternRules> hashRuleMap;
    private final boolean fDefaultHashCode;

    public HashedOrderlessMatcher(boolean defaultHashCode) {
        this.fDefaultHashCode = defaultHashCode;
        this.hashRuleMap = ArrayListMultimap.create();
    }

    public void setUpHashRule(String lhs1Str, String lhs2Str, String rhsStr) throws SyntaxError {
        this.setUpHashRule(lhs1Str, lhs2Str, rhsStr, null);
    }

    public void setUpHashRule(String lhs1Str, String lhs2Str, String rhsStr, String conditionStr) throws SyntaxError {
        Parser parser = new Parser();
        ASTNode parsedAST = parser.parse(lhs1Str);
        IExpr lhs1 = AST2Expr.CONST.convert(parsedAST);
        parsedAST = parser.parse(lhs2Str);
        IExpr lhs2 = AST2Expr.CONST.convert(parsedAST);
        parsedAST = parser.parse(rhsStr);
        IExpr rhs = AST2Expr.CONST.convert(parsedAST);
        IExpr condition = null;
        if (conditionStr != null) {
            parsedAST = parser.parse(conditionStr);
            condition = AST2Expr.CONST.convert(parsedAST);
        }
        this.setUpHashRule(lhs1, lhs2, rhs, condition);
    }

    private void setUpHashRule(IExpr lhs1, IExpr lhs2, IExpr rhs, IExpr condition) {
        HashedPatternRules hashRule = new HashedPatternRules(lhs1, lhs2, rhs, condition, this.fDefaultHashCode);
        this.hashRuleMap.put((Object)hashRule.getHash1(), (Object)hashRule);
    }

    public IAST evaluate(IAST orderlessAST) {
        int[] hashValues = new int[orderlessAST.size() - 1];
        if (this.fDefaultHashCode) {
            int i = 0;
            while (i < hashValues.length) {
                hashValues[i] = ((IExpr)orderlessAST.get(i + 1)).head().hashCode();
                ++i;
            }
        } else {
            HashValueVisitor v = new HashValueVisitor();
            int i = 0;
            while (i < hashValues.length) {
                hashValues[i] = ((IExpr)orderlessAST.get(i + 1)).accept(v);
                v.setUp();
                ++i;
            }
        }
        return this.evaluateHashedValues(orderlessAST, hashValues);
    }

    private IAST evaluateHashedValues(IAST orderlessAST, int[] hashValues) {
        boolean evaled = false;
        List result = null;
        int i = 0;
        while (i < hashValues.length) {
            List hashRuleList;
            if (hashValues[i] != 0 && (hashRuleList = this.hashRuleMap.get((Object)hashValues[i])) != null) {
                block1: for (HashedPatternRules hashRule : hashRuleList) {
                    int j = 0;
                    while (j < hashValues.length) {
                        RulesData rulesData;
                        IExpr temp;
                        if (hashValues[j] == hashRule.getHash2() && j != i && (temp = (rulesData = hashRule.getRulesData()).evalDownRule(F.List((IExpr)orderlessAST.get(i + 1), (IExpr)orderlessAST.get(j + 1)))) != null) {
                            hashValues[i] = 0;
                            hashValues[j] = 0;
                            if (!evaled) {
                                result = orderlessAST.copyHead();
                                evaled = true;
                            }
                            result.add(temp);
                            break block1;
                        }
                        ++j;
                    }
                }
            }
            ++i;
        }
        if (evaled) {
            i = 0;
            while (i < hashValues.length) {
                if (hashValues[i] != 0) {
                    result.add((IExpr)orderlessAST.get(i + 1));
                }
                ++i;
            }
        }
        return result;
    }
}

