/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.patternmatching;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.matheclipse.core.eval.EvalEngine;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.IPattern;
import org.matheclipse.core.interfaces.IPatternMatcher;
import org.matheclipse.core.interfaces.ISymbol;
import org.matheclipse.core.list.algorithms.EvaluationSupport;
import org.matheclipse.generic.combinatoric.KPartitionsIterable;
import org.matheclipse.generic.combinatoric.KPermutationsIterable;

public class PatternMatcher
extends IPatternMatcher<IExpr>
implements Serializable {
    private static final long serialVersionUID = -6708462090303928690L;
    protected IExpr fCondition = null;
    protected transient int fPatternCounter = 0;
    protected IExpr fLeftHandSide;
    protected transient IExpr[] fPatternValuesArray = null;
    protected transient ArrayList<ISymbol> fPatternSymbolsArray = null;

    public PatternMatcher() {
        this(null);
    }

    public PatternMatcher(IExpr patternExpr) {
        this.fLeftHandSide = patternExpr;
        this.init(this.fLeftHandSide);
    }

    protected final void init(IExpr patternExpr) {
        HashMap<ISymbol, Integer> patternIndexMap = new HashMap<ISymbol, Integer>();
        this.fPatternSymbolsArray = new ArrayList(5);
        this.determinePatterns(patternExpr, patternIndexMap);
        if (this.fPatternCounter != 0) {
            this.fPatternValuesArray = new IExpr[this.fPatternCounter];
        }
    }

    @Override
    public boolean checkPatternMatcher(PatternMatcher thatMatcher) {
        if (this.fPatternCounter == 0 || thatMatcher.fPatternCounter == 0) {
            return true;
        }
        int i = 0;
        while (i < this.fPatternSymbolsArray.size()) {
            int j = 0;
            while (j < thatMatcher.fPatternSymbolsArray.size()) {
                if (this.fPatternSymbolsArray.get(i).equals(thatMatcher.fPatternSymbolsArray.get(j)) && !this.fPatternValuesArray[i].equals(thatMatcher.fPatternValuesArray[j])) {
                    return false;
                }
                ++j;
            }
            ++i;
        }
        return true;
    }

    public boolean checkCondition() {
        if (this.fCondition != null) {
            if (this.fPatternValuesArray != null) {
                int i = 0;
                while (i < this.fPatternValuesArray.length) {
                    if (this.fPatternValuesArray[i] == null) {
                        return true;
                    }
                    ++i;
                }
            }
            EvalEngine engine = EvalEngine.get();
            boolean traceMode = false;
            try {
                IExpr substConditon = EvaluationSupport.substituteLocalVariables(this.fCondition, this.fPatternSymbolsArray, this.fPatternValuesArray);
                traceMode = engine.isTraceMode();
                engine.setTraceMode(false);
                boolean bl = engine.evaluate(substConditon).equals(F.True);
                return bl;
            }
            finally {
                if (traceMode) {
                    engine.setTraceMode(true);
                }
            }
        }
        return true;
    }

    public static boolean equivalent(IExpr patternExpr1, IExpr patternExpr2) {
        if (patternExpr1 instanceof IAST && patternExpr2 instanceof IAST) {
            IAST l1 = (IAST)patternExpr1;
            IAST l2 = (IAST)patternExpr2;
            if (l1.size() != l2.size()) {
                return false;
            }
            if (!PatternMatcher.equivalent(l1.head(), l2.head())) {
                return false;
            }
            int i = 1;
            while (i < l1.size()) {
                if (!PatternMatcher.equivalent((IExpr)l1.get(i), (IExpr)l2.get(i))) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        if (patternExpr1 instanceof IPattern && patternExpr2 instanceof IPattern) {
            IPattern p1 = (IPattern)patternExpr1;
            IPattern p2 = (IPattern)patternExpr2;
            if (p1.getIndex() != p2.getIndex()) {
                return false;
            }
            IExpr o1 = p1.getCondition();
            IExpr o2 = p2.getCondition();
            if (o1 == null || o2 == null) {
                return o1 == o2;
            }
            return o1.equals(o2);
        }
        return patternExpr1.equals(patternExpr2);
    }

    private int determinePatterns(IExpr lhsExprWithPattern, HashMap<ISymbol, Integer> patternIndexMap) {
        if (lhsExprWithPattern instanceof IAST) {
            IAST ast = (IAST)lhsExprWithPattern;
            int listEvalFlags = 0;
            listEvalFlags |= this.determinePatterns(ast.head(), patternIndexMap);
            int i = 1;
            while (i < ast.size()) {
                if (ast.get(i) instanceof IPattern) {
                    IPattern pat = (IPattern)ast.get(i);
                    this.determinePatternParameters(pat, patternIndexMap);
                    listEvalFlags = pat.isDefault() ? (listEvalFlags |= 2) : (listEvalFlags |= 1);
                } else {
                    listEvalFlags |= this.determinePatterns((IExpr)ast.get(i), patternIndexMap);
                }
                ++i;
            }
            ast.setEvalFlags(listEvalFlags);
            return listEvalFlags &= 0xFFFD;
        }
        if (lhsExprWithPattern instanceof IPattern) {
            this.determinePatternParameters((IPattern)lhsExprWithPattern, patternIndexMap);
            return 1;
        }
        return 0;
    }

    private void determinePatternParameters(IPattern pattern, HashMap<ISymbol, Integer> patternIndexMap) {
        if (pattern.getSymbol() == null) {
            pattern.setIndex(this.fPatternCounter++);
            this.fPatternSymbolsArray.add(null);
        } else {
            Integer mappedPattern = patternIndexMap.get(pattern.getSymbol());
            if (mappedPattern != null) {
                pattern.setIndex(mappedPattern);
            } else {
                pattern.setIndex(this.fPatternCounter);
                this.fPatternSymbolsArray.add(pattern.getSymbol());
                patternIndexMap.put(pattern.getSymbol(), this.fPatternCounter++);
            }
        }
    }

    public IExpr getCondition() {
        return this.fCondition;
    }

    @Override
    public void getPatterns(List<IExpr> resultList, IExpr pExpr) {
        if (pExpr instanceof IAST) {
            IAST list = (IAST)pExpr;
            this.getPatterns(resultList, list.head());
            int i = 0;
            while (i < list.size()) {
                this.getPatterns(resultList, (IExpr)list.get(i));
                ++i;
            }
        } else if (pExpr instanceof IPattern) {
            IExpr value = this.fPatternValuesArray[((IPattern)pExpr).getIndex()];
            resultList.add(value);
        }
    }

    public void setPatternValue2Local(IExpr pExpr) {
        if (pExpr instanceof IAST) {
            IAST list = (IAST)pExpr;
            this.setPatternValue2Local(list.head());
            int i = 0;
            while (i < list.size()) {
                this.setPatternValue2Local((IExpr)list.get(i));
                ++i;
            }
        } else if (pExpr instanceof IPattern) {
            ISymbol sym = ((IPattern)pExpr).getSymbol();
            if (!sym.hasLocalVariableStack()) {
                throw new UnsupportedOperationException("Pattern symbol has to be defined with local stack");
            }
            IExpr value = this.fPatternValuesArray[((IPattern)pExpr).getIndex()];
            sym.set(value);
        }
    }

    protected void initPattern() {
        int i = 0;
        while (i < this.fPatternCounter) {
            this.fPatternValuesArray[i] = null;
            ++i;
        }
    }

    protected IExpr[] copyPattern() {
        IExpr[] patternValuesArray = new IExpr[this.fPatternValuesArray.length];
        System.arraycopy(this.fPatternValuesArray, 0, patternValuesArray, 0, this.fPatternValuesArray.length);
        return patternValuesArray;
    }

    protected void resetPattern(IExpr[] patternValuesArray) {
        System.arraycopy(patternValuesArray, 0, this.fPatternValuesArray, 0, this.fPatternValuesArray.length);
    }

    @Override
    public final boolean isRuleWithoutPatterns() {
        return this.fPatternCounter == 0;
    }

    @Override
    public boolean apply(IExpr evalExpr) {
        if (this.fPatternCounter == 0) {
            return this.fLeftHandSide.equals(evalExpr);
        }
        this.initPattern();
        return this.matchExpr(this.fLeftHandSide, evalExpr);
    }

    protected boolean matchExpr(IExpr lhsPatternExpression, IExpr rhsExpression) {
        if (lhsPatternExpression instanceof IAST) {
            IAST ast = (IAST)lhsPatternExpression;
            IExpr[] patternValues = null;
            if ((ast.getEvalFlags() & 2) == 2) {
                patternValues = this.copyPattern();
            }
            if (!this.matchAST(ast, rhsExpression)) {
                if ((ast.getEvalFlags() & 2) == 2) {
                    IExpr temp = null;
                    ISymbol symbol = ast.topHead();
                    int attr = symbol.getAttributes();
                    this.resetPattern(patternValues);
                    temp = this.matchDefaultAST(symbol, attr, ast);
                    if (temp != null) {
                        return this.matchExpr(temp, rhsExpression);
                    }
                }
                return false;
            }
            return true;
        }
        if (lhsPatternExpression instanceof IPattern) {
            return this.matchPattern((IPattern)lhsPatternExpression, rhsExpression);
        }
        return lhsPatternExpression.equals(rhsExpression);
    }

    /*
     * Unable to fully structure code
     */
    private IExpr matchDefaultAST(ISymbol symbol, int attr, IAST ast) {
        commonDefaultValue = symbol.getDefaultValue();
        cloned = F.ast(ast.head(), ast.size(), false);
        positionDefaultValue = null;
        i = 1;
        while (i < ast.size()) {
            if (!(ast.get(i) instanceof IPattern) || !((IPattern)ast.get(i)).isDefault()) ** GOTO lbl-1000
            positionDefaultValue = symbol.getDefaultValue(i);
            if (positionDefaultValue != null) {
                if (!this.matchPattern((IPattern)ast.get(i), positionDefaultValue)) {
                    return null;
                }
            } else if (commonDefaultValue != null) {
                if (!this.matchPattern((IPattern)ast.get(i), commonDefaultValue)) {
                    return null;
                }
            } else lbl-1000:
            // 2 sources

            {
                cloned.add((IExpr)ast.get(i));
            }
            ++i;
        }
        if (cloned.size() == 2) {
            return (IExpr)cloned.get(1);
        }
        return null;
    }

    private boolean matchFlatList(ISymbol sym, IAST lhsPatternList, IAST lhsEvalList) {
        if ((sym.getAttributes() & 4) == 4) {
            FlatOrderlessMatcher foMatcher = new FlatOrderlessMatcher(sym, lhsPatternList, lhsEvalList);
            return foMatcher.matchFlatOrderlessList();
        }
        FlatMatcher fMatcher = new FlatMatcher(sym, lhsPatternList, lhsEvalList);
        return fMatcher.matchFlatList();
    }

    private boolean matchAST(IAST lhsPatternExpression, IExpr lhsEvalExpression) {
        if (lhsEvalExpression instanceof IAST) {
            IExpr temp;
            IAST lhsEvalList = (IAST)lhsEvalExpression;
            ISymbol sym = lhsPatternExpression.topHead();
            if (lhsEvalList.size() > lhsPatternExpression.size()) {
                if ((sym.getAttributes() & 8) == 8 && lhsPatternExpression.head().equals(lhsEvalList.head())) {
                    if (!this.matchExpr(lhsPatternExpression.head(), lhsEvalList.head())) {
                        return false;
                    }
                    return this.matchFlatList(sym, lhsPatternExpression, lhsEvalList);
                }
                return false;
            }
            if (lhsEvalList.size() != lhsPatternExpression.size()) {
                return false;
            }
            if (!this.matchExpr(lhsPatternExpression.head(), lhsEvalList.head())) {
                return false;
            }
            if ((sym.getAttributes() & 4) == 4) {
                OrderlessMatcher foMatcher = new OrderlessMatcher(lhsPatternExpression, lhsEvalList);
                return foMatcher.matchOrderlessList();
            }
            int i = 1;
            while (i < lhsPatternExpression.size()) {
                temp = (IExpr)lhsPatternExpression.get(i);
                if (!(temp instanceof IAST && ((IAST)temp).isEvalFlagOn(1) || this.matchExpr(temp, (IExpr)lhsEvalList.get(i)))) {
                    return false;
                }
                ++i;
            }
            i = 1;
            while (i < lhsPatternExpression.size()) {
                temp = (IExpr)lhsPatternExpression.get(i);
                if (temp instanceof IAST && ((IAST)temp).isEvalFlagOn(1) && !this.matchExpr(temp, (IExpr)lhsEvalList.get(i))) {
                    return false;
                }
                ++i;
            }
            return this.checkCondition();
        }
        return false;
    }

    private boolean matchPattern(IPattern pattern, IExpr expr) {
        if (!pattern.isConditionMatched(expr)) {
            return false;
        }
        IExpr value = this.fPatternValuesArray[pattern.getIndex()];
        if (value != null) {
            return expr.equals(value);
        }
        this.fPatternValuesArray[pattern.getIndex()] = expr;
        return true;
    }

    @Override
    public void setCondition(IExpr condition) {
        this.fCondition = condition;
    }

    public IExpr getLHS() {
        return this.fLeftHandSide;
    }

    @Override
    public IExpr eval(IExpr leftHandSide) {
        return null;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof PatternMatcher) {
            PatternMatcher pm = (PatternMatcher)obj;
            if (this.fPatternCounter != pm.fPatternCounter) {
                return false;
            }
            if (this.fPatternCounter == 0) {
                return this.fLeftHandSide.equals(pm.fLeftHandSide);
            }
            if (PatternMatcher.equivalent(this.fLeftHandSide, pm.fLeftHandSide)) {
                if (this.fCondition != null && pm.fCondition != null) {
                    return this.fCondition.equals(pm.fCondition);
                }
                return this.fCondition == null && pm.fCondition == null;
            }
        }
        return false;
    }

    public int hashCode() {
        return this.fLeftHandSide.hashCode();
    }

    @Override
    public Object clone() {
        PatternMatcher v = (PatternMatcher)super.clone();
        v.fCondition = this.fCondition;
        v.fPatternCounter = this.fPatternCounter;
        v.fLeftHandSide = this.fLeftHandSide;
        v.fPatternValuesArray = Arrays.copyOf(this.fPatternValuesArray, this.fPatternValuesArray.length);
        v.fPatternSymbolsArray = (ArrayList)this.fPatternSymbolsArray.clone();
        return v;
    }

    public class FlatMatcher {
        private IAST fLhsPatternList;
        private final boolean fOneIdentity;
        private int[] fPartitionsIndex;
        private ISymbol fSymbol;
        private IAST lhsEvalList;

        public FlatMatcher(ISymbol sym, IAST lhsPatternList, IAST lhsEvalList) {
            this.fSymbol = sym;
            this.fLhsPatternList = lhsPatternList;
            this.lhsEvalList = lhsEvalList;
            this.fOneIdentity = (sym.getAttributes() & 1) == 1;
        }

        public boolean matchFlatList() {
            int n = this.lhsEvalList.size() - 1;
            int k = this.fLhsPatternList.size() - 1;
            KPartitionsIterable partitionIterator = new KPartitionsIterable(n, k);
            IExpr[] localPatternValuesArrayCopy = new IExpr[PatternMatcher.this.fPatternValuesArray.length];
            System.arraycopy(PatternMatcher.this.fPatternValuesArray, 0, localPatternValuesArrayCopy, 0, PatternMatcher.this.fPatternValuesArray.length);
            for (int[] partitionsIndex : partitionIterator) {
                this.fPartitionsIndex = partitionsIndex;
                if (this.matchSingleFlatPartition() && PatternMatcher.this.checkCondition()) {
                    return true;
                }
                System.arraycopy(localPatternValuesArrayCopy, 0, PatternMatcher.this.fPatternValuesArray, 0, PatternMatcher.this.fPatternValuesArray.length);
            }
            return false;
        }

        private boolean matchSingleFlatPartition() {
            IAST partitionElement;
            int n = this.lhsEvalList.size() - 1;
            int partitionStartIndex = 0;
            int partitionElementCounter = 0;
            int i = 1;
            while (i < this.fPartitionsIndex.length) {
                if (partitionStartIndex + 1 == this.fPartitionsIndex[i]) {
                    if (this.fOneIdentity) {
                        if (!PatternMatcher.this.matchExpr((IExpr)this.fLhsPatternList.get(partitionElementCounter + 1), (IExpr)this.lhsEvalList.get(partitionStartIndex + 1))) {
                            return false;
                        }
                    } else {
                        partitionElement = F.function(this.fSymbol);
                        partitionElement.add((IExpr)this.lhsEvalList.get(partitionStartIndex + 1));
                        if (!PatternMatcher.this.matchExpr((IExpr)this.fLhsPatternList.get(partitionElementCounter + 1), partitionElement)) {
                            return false;
                        }
                    }
                } else {
                    partitionElement = F.function(this.fSymbol);
                    int m = partitionStartIndex;
                    while (m < this.fPartitionsIndex[i]) {
                        if (m + 1 < this.fPartitionsIndex[i] && ((IExpr)this.lhsEvalList.get(m + 2)).isLTOrdered((IExpr)this.lhsEvalList.get(m + 1))) {
                            return false;
                        }
                        partitionElement.add((IExpr)this.lhsEvalList.get(m + 1));
                        ++m;
                    }
                    if (!PatternMatcher.this.matchExpr((IExpr)this.fLhsPatternList.get(partitionElementCounter + 1), partitionElement)) {
                        return false;
                    }
                }
                ++partitionElementCounter;
                partitionStartIndex = this.fPartitionsIndex[i];
                ++i;
            }
            if (partitionStartIndex + 1 == n) {
                if (this.fOneIdentity) {
                    if (!PatternMatcher.this.matchExpr((IExpr)this.fLhsPatternList.get(partitionElementCounter + 1), (IExpr)this.lhsEvalList.get(partitionStartIndex + 1))) {
                        return false;
                    }
                } else {
                    partitionElement = F.function(this.fSymbol);
                    partitionElement.add((IExpr)this.lhsEvalList.get(partitionStartIndex + 1));
                    if (!PatternMatcher.this.matchExpr((IExpr)this.fLhsPatternList.get(partitionElementCounter + 1), partitionElement)) {
                        return false;
                    }
                }
            } else {
                partitionElement = F.function(this.fSymbol);
                int m = partitionStartIndex;
                while (m < n) {
                    if (m + 1 < n && ((IExpr)this.lhsEvalList.get(m + 2)).isLTOrdered((IExpr)this.lhsEvalList.get(m + 1))) {
                        return false;
                    }
                    partitionElement.add((IExpr)this.lhsEvalList.get(m + 1));
                    ++m;
                }
                if (!PatternMatcher.this.matchExpr((IExpr)this.fLhsPatternList.get(partitionElementCounter + 1), partitionElement)) {
                    return false;
                }
            }
            return true;
        }
    }

    public class FlatOrderlessMatcher {
        private IAST fLhsPatternList;
        private boolean fOneIdentity;
        private int[] fPartitionsIndex;
        private int[] fPermutationsIndex;
        private ISymbol fSymbol;
        private IAST lhsEvalList;

        public FlatOrderlessMatcher(ISymbol sym, IAST lhsPatternList, IAST lhsEvalList) {
            this.fSymbol = sym;
            this.fLhsPatternList = lhsPatternList;
            this.lhsEvalList = lhsEvalList;
            this.fOneIdentity = (sym.getAttributes() & 1) == 1;
        }

        public boolean matchFlatOrderlessList() {
            int n = this.lhsEvalList.size() - 1;
            int k = this.fLhsPatternList.size() - 1;
            KPermutationsIterable permutationIterator = new KPermutationsIterable(this.lhsEvalList, n, 1);
            KPartitionsIterable partitionIterator = new KPartitionsIterable(n, k);
            IExpr[] localPatternValuesArrayCopy = new IExpr[PatternMatcher.this.fPatternValuesArray.length];
            System.arraycopy(PatternMatcher.this.fPatternValuesArray, 0, localPatternValuesArrayCopy, 0, PatternMatcher.this.fPatternValuesArray.length);
            for (int[] permutationsIndex : permutationIterator) {
                this.fPermutationsIndex = permutationsIndex;
                for (int[] partitionsIndex : partitionIterator) {
                    this.fPartitionsIndex = partitionsIndex;
                    if (this.matchSingleFlatOrderlessPartition() && PatternMatcher.this.checkCondition()) {
                        return true;
                    }
                    System.arraycopy(localPatternValuesArrayCopy, 0, PatternMatcher.this.fPatternValuesArray, 0, PatternMatcher.this.fPatternValuesArray.length);
                }
                partitionIterator.reset();
            }
            return false;
        }

        private boolean matchSingleFlatOrderlessPartition() {
            IAST partitionElement;
            int n = this.lhsEvalList.size() - 1;
            int partitionStartIndex = 0;
            int partitionElementCounter = 0;
            int i = 1;
            while (i < this.fPartitionsIndex.length) {
                if (partitionStartIndex + 1 == this.fPartitionsIndex[i]) {
                    if (this.fOneIdentity) {
                        if (!PatternMatcher.this.matchExpr((IExpr)this.fLhsPatternList.get(partitionElementCounter + 1), (IExpr)this.lhsEvalList.get(this.fPermutationsIndex[partitionStartIndex] + 1))) {
                            return false;
                        }
                    } else {
                        partitionElement = F.function(this.fSymbol);
                        partitionElement.add((IExpr)this.lhsEvalList.get(this.fPermutationsIndex[partitionStartIndex] + 1));
                        if (!PatternMatcher.this.matchExpr((IExpr)this.fLhsPatternList.get(partitionElementCounter + 1), partitionElement)) {
                            return false;
                        }
                    }
                } else {
                    partitionElement = F.function(this.fSymbol);
                    int m = partitionStartIndex;
                    while (m < this.fPartitionsIndex[i]) {
                        if (m + 1 < this.fPartitionsIndex[i] && ((IExpr)this.lhsEvalList.get(this.fPermutationsIndex[m + 1] + 1)).isLTOrdered((IExpr)this.lhsEvalList.get(this.fPermutationsIndex[m] + 1))) {
                            return false;
                        }
                        partitionElement.add((IExpr)this.lhsEvalList.get(this.fPermutationsIndex[m] + 1));
                        ++m;
                    }
                    if (!PatternMatcher.this.matchExpr((IExpr)this.fLhsPatternList.get(partitionElementCounter + 1), partitionElement)) {
                        return false;
                    }
                }
                ++partitionElementCounter;
                partitionStartIndex = this.fPartitionsIndex[i];
                ++i;
            }
            if (partitionStartIndex + 1 == n) {
                if (this.fOneIdentity) {
                    if (!PatternMatcher.this.matchExpr((IExpr)this.fLhsPatternList.get(partitionElementCounter + 1), (IExpr)this.lhsEvalList.get(this.fPermutationsIndex[partitionStartIndex] + 1))) {
                        return false;
                    }
                } else {
                    partitionElement = F.function(this.fSymbol);
                    partitionElement.add((IExpr)this.lhsEvalList.get(this.fPermutationsIndex[partitionStartIndex] + 1));
                    if (!PatternMatcher.this.matchExpr((IExpr)this.fLhsPatternList.get(partitionElementCounter + 1), partitionElement)) {
                        return false;
                    }
                }
            } else {
                partitionElement = F.function(this.fSymbol);
                int m = partitionStartIndex;
                while (m < n) {
                    if (m + 1 < n && ((IExpr)this.lhsEvalList.get(this.fPermutationsIndex[m + 1] + 1)).isLTOrdered((IExpr)this.lhsEvalList.get(this.fPermutationsIndex[m] + 1))) {
                        return false;
                    }
                    partitionElement.add((IExpr)this.lhsEvalList.get(this.fPermutationsIndex[m] + 1));
                    ++m;
                }
                if (!PatternMatcher.this.matchExpr((IExpr)this.fLhsPatternList.get(partitionElementCounter + 1), partitionElement)) {
                    return false;
                }
            }
            return true;
        }
    }

    public class OrderlessMatcher {
        private IAST fLhsPatternList;
        private int[] fPermutationsIndex;
        private IAST lhsEvalList;

        public OrderlessMatcher(IAST lhsPatternList, IAST lhsEvalList) {
            this.fLhsPatternList = lhsPatternList;
            this.lhsEvalList = lhsEvalList;
        }

        public boolean matchOrderlessList() {
            int n = this.lhsEvalList.size() - 1;
            KPermutationsIterable permutationIterator = new KPermutationsIterable(this.lhsEvalList, n, 1);
            IExpr[] localPatternValuesArrayCopy = new IExpr[PatternMatcher.this.fPatternValuesArray.length];
            System.arraycopy(PatternMatcher.this.fPatternValuesArray, 0, localPatternValuesArrayCopy, 0, PatternMatcher.this.fPatternValuesArray.length);
            for (int[] permutationsIndex : permutationIterator) {
                this.fPermutationsIndex = permutationsIndex;
                if (this.matchSingleOrderlessPermutation() && PatternMatcher.this.checkCondition()) {
                    return true;
                }
                System.arraycopy(localPatternValuesArrayCopy, 0, PatternMatcher.this.fPatternValuesArray, 0, PatternMatcher.this.fPatternValuesArray.length);
            }
            return false;
        }

        private boolean matchSingleOrderlessPermutation() {
            int i = 0;
            while (i < this.fPermutationsIndex.length) {
                if (!PatternMatcher.this.matchExpr((IExpr)this.fLhsPatternList.get(i + 1), (IExpr)this.lhsEvalList.get(this.fPermutationsIndex[i] + 1))) {
                    return false;
                }
                ++i;
            }
            return true;
        }
    }
}

