/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.patternmatching;

import java.io.Serializable;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.ISymbol;
import org.matheclipse.core.list.algorithms.EvaluationSupport;
import org.matheclipse.core.patternmatching.PatternMatcher;

public class PatternMatcherAndEvaluator
extends PatternMatcher
implements Serializable {
    private static final long serialVersionUID = 2241135467123931061L;
    private IExpr fRightHandSide;
    private ISymbol fSetSymbol;

    public PatternMatcherAndEvaluator(ISymbol setSymbol, IExpr leftHandSide, IExpr rightHandSide) {
        super(leftHandSide);
        this.fSetSymbol = setSymbol;
        this.fRightHandSide = rightHandSide;
    }

    @Override
    public Object clone() {
        PatternMatcherAndEvaluator v = (PatternMatcherAndEvaluator)super.clone();
        v.fRightHandSide = this.fRightHandSide;
        v.fSetSymbol = this.fSetSymbol;
        return v;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof PatternMatcherAndEvaluator) {
            return super.equals(obj);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return super.hashCode() * 53;
    }

    @Override
    public IExpr eval(IExpr leftHandSide) {
        if (this.fPatternCounter == 0) {
            if (this.fLeftHandSide.equals(leftHandSide)) {
                return this.fRightHandSide;
            }
            return null;
        }
        this.initPattern();
        if (this.matchExpr(this.fLeftHandSide, leftHandSide) && this.checkCondition()) {
            return EvaluationSupport.substituteLocalVariables(this.fRightHandSide, this.fPatternSymbolsArray, this.fPatternValuesArray);
        }
        return null;
    }

    public IExpr getRHS() {
        return this.fRightHandSide;
    }

    public ISymbol getSetSymbol() {
        return this.fSetSymbol;
    }
}

