/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.patternmatching;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import org.matheclipse.core.convert.AST2Expr;
import org.matheclipse.core.eval.interfaces.IFunctionEvaluator;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.patternmatching.PatternMatcher;
import org.matheclipse.parser.client.Parser;
import org.matheclipse.parser.client.ast.ASTNode;

public class PatternMatcherAndInvoker
extends PatternMatcher {
    private static final long serialVersionUID = -2448717771259975643L;
    private transient Method fMethod;
    private transient Type[] fTypes;
    private transient IFunctionEvaluator fInstance;

    @Override
    public Object clone() {
        PatternMatcherAndInvoker v = (PatternMatcherAndInvoker)super.clone();
        v.fMethod = this.fMethod;
        v.fTypes = this.fTypes;
        v.fInstance = this.fInstance;
        return v;
    }

    public PatternMatcherAndInvoker(IExpr leftHandSide, IFunctionEvaluator instance, String methodName) {
        super(leftHandSide);
        this.fInstance = instance;
        this.initInvoker(instance, methodName);
    }

    public PatternMatcherAndInvoker(String leftHandSide, IFunctionEvaluator instance, String methodName) {
        IExpr lhs;
        this.fInstance = instance;
        Parser parser = new Parser();
        ASTNode node = parser.parse(leftHandSide);
        this.fLeftHandSide = lhs = AST2Expr.CONST.convert(node);
        this.init(this.fLeftHandSide);
        this.initInvoker(instance, methodName);
    }

    private void initInvoker(IFunctionEvaluator instance, String methodName) {
        Class<?> c = instance.getClass();
        Method[] declaredMethods = c.getDeclaredMethods();
        ArrayList<Method> namedMethods = new ArrayList<Method>();
        Method[] methodArray = declaredMethods;
        int n = declaredMethods.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            if (method.getName().equals(methodName)) {
                namedMethods.add(method);
            }
            ++n2;
        }
        if (namedMethods.size() == 1) {
            this.fMethod = (Method)namedMethods.get(0);
            this.fTypes = this.fMethod.getGenericParameterTypes();
        }
    }

    @Override
    public IExpr eval(IExpr leftHandSide) {
        IExpr result = null;
        if (this.fPatternCounter == 0 && this.fLeftHandSide.equals(leftHandSide)) {
            if (this.fTypes.length != 0) {
                return null;
            }
            try {
                result = (IExpr)this.fMethod.invoke((Object)this.fInstance, new Object[0]);
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
            return result;
        }
        if (this.fTypes.length != this.fPatternSymbolsArray.size()) {
            return null;
        }
        this.initPattern();
        if (this.matchExpr(this.fLeftHandSide, leftHandSide) && this.checkCondition()) {
            ArrayList<IExpr> args = new ArrayList<IExpr>(this.fPatternSymbolsArray.size());
            int i = 0;
            while (i < this.fPatternSymbolsArray.size()) {
                IExpr arg = this.fPatternValuesArray[i];
                if (arg == null) {
                    return null;
                }
                args.add(arg);
                ++i;
            }
            result = null;
            try {
                result = (IExpr)this.fMethod.invoke((Object)this.fInstance, args.toArray());
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof PatternMatcherAndInvoker) {
            return super.equals(obj);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return super.hashCode() * 47;
    }
}

