/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.patternmatching;

import com.google.common.collect.ArrayListMultimap;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.matheclipse.basic.Config;
import org.matheclipse.core.eval.EvalEngine;
import org.matheclipse.core.eval.exception.RuleCreationError;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IEvaluationEngine;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.IPattern;
import org.matheclipse.core.interfaces.IPatternMatcher;
import org.matheclipse.core.interfaces.ISymbol;
import org.matheclipse.core.patternmatching.PatternMatcher;
import org.matheclipse.core.patternmatching.PatternMatcherAndEvaluator;
import org.matheclipse.core.patternmatching.PatternMatcherAndInvoker;
import org.matheclipse.generic.interfaces.Pair;

public class RulesData {
    private Map<IExpr, Pair<ISymbol, IExpr>> fEqualRules = null;
    private ArrayListMultimap<Integer, IPatternMatcher<IExpr>> fSimplePatternRules = null;
    private List<IPatternMatcher<IExpr>> fPatternRules = null;

    public void clear() {
        this.fEqualRules = null;
        this.fSimplePatternRules = null;
        this.fPatternRules = null;
    }

    public IExpr evalDownRule(IExpr expression) {
        return this.evalDownRule(EvalEngine.get(), expression);
    }

    public IExpr evalDownRule(IEvaluationEngine ee, IExpr expression) {
        IExpr result;
        IPatternMatcher pmEvaluator;
        Integer hash;
        List list;
        Pair<ISymbol, IExpr> res;
        if (this.fEqualRules != null && (res = this.fEqualRules.get(expression)) != null) {
            return res.getSecond();
        }
        if (this.fSimplePatternRules != null && expression instanceof IAST && (list = this.fSimplePatternRules.get((Object)(hash = Integer.valueOf(((IAST)expression).patternHashCode())))) != null) {
            int i = 0;
            while (i < list.size()) {
                pmEvaluator = Config.SERVER_MODE ? (IPatternMatcher)((IPatternMatcher)list.get(i)).clone() : (IPatternMatcher)list.get(i);
                result = pmEvaluator.eval(expression);
                if (result != null) {
                    return result;
                }
                ++i;
            }
        }
        if (this.fPatternRules != null) {
            int i = 0;
            while (i < this.fPatternRules.size()) {
                pmEvaluator = Config.SERVER_MODE ? (IPatternMatcher)this.fPatternRules.get(i).clone() : this.fPatternRules.get(i);
                result = pmEvaluator.eval(expression);
                if (result != null) {
                    return result;
                }
                ++i;
            }
        }
        return null;
    }

    public PatternMatcher putDownRule(ISymbol setSymbol, boolean equalRule, IExpr leftHandSide, IExpr rightHandSide, IExpr condition, int priority) {
        if (equalRule) {
            this.fEqualRules = this.getEqualRules();
            this.fEqualRules.put(leftHandSide, new Pair<ISymbol, IExpr>(setSymbol, rightHandSide));
            if (condition != null) {
                throw new RuleCreationError(leftHandSide, rightHandSide, condition);
            }
            return null;
        }
        PatternMatcherAndEvaluator pmEvaluator = new PatternMatcherAndEvaluator(setSymbol, leftHandSide, rightHandSide);
        if (pmEvaluator.isRuleWithoutPatterns()) {
            this.fEqualRules = this.getEqualRules();
            this.fEqualRules.put(leftHandSide, new Pair<ISymbol, IExpr>(setSymbol, rightHandSide));
            if (condition != null) {
                throw new RuleCreationError(leftHandSide, rightHandSide, condition);
            }
            return null;
        }
        pmEvaluator.setCondition(condition);
        if (!this.isComplicatedPatternRule(leftHandSide)) {
            this.fSimplePatternRules = this.getSimplePatternRules();
            return this.addSimplePatternRule(leftHandSide, pmEvaluator);
        }
        this.fPatternRules = this.getPatternRules();
        int i = 0;
        while (i < this.fPatternRules.size()) {
            if (pmEvaluator.equals(this.fPatternRules.get(i))) {
                this.fPatternRules.set(i, pmEvaluator);
                return pmEvaluator;
            }
            ++i;
        }
        this.fPatternRules.add(pmEvaluator);
        return pmEvaluator;
    }

    private PatternMatcher addSimplePatternRule(IExpr leftHandSide, PatternMatcher pmEvaluator) {
        Integer hash = ((IAST)leftHandSide).patternHashCode();
        if (this.fSimplePatternRules.containsEntry((Object)hash, (Object)pmEvaluator)) {
            this.fSimplePatternRules.remove((Object)hash, (Object)pmEvaluator);
        }
        this.fSimplePatternRules.put((Object)hash, (Object)pmEvaluator);
        return pmEvaluator;
    }

    public PatternMatcher putDownRule(PatternMatcherAndInvoker pmEvaluator) {
        IExpr leftHandSide = pmEvaluator.getLHS();
        if (!this.isComplicatedPatternRule(leftHandSide)) {
            this.fSimplePatternRules = this.getSimplePatternRules();
            return this.addSimplePatternRule(leftHandSide, pmEvaluator);
        }
        this.fPatternRules = this.getPatternRules();
        int i = 0;
        while (i < this.fPatternRules.size()) {
            if (pmEvaluator.equals(this.fPatternRules.get(i))) {
                this.fPatternRules.set(i, pmEvaluator);
                return pmEvaluator;
            }
            ++i;
        }
        this.fPatternRules.add(pmEvaluator);
        return pmEvaluator;
    }

    private boolean isComplicatedPatternRule(IExpr patternExpr) {
        if (patternExpr instanceof IAST) {
            IAST ast = (IAST)patternExpr;
            if (ast.size() > 1) {
                if (ast.get(1) instanceof IPattern) {
                    return true;
                }
                int attr = ast.topHead().getAttributes();
                if ((4 & attr) == 4) {
                    return true;
                }
                int i = 2;
                while (i < ast.size()) {
                    if (ast.get(i) instanceof IPattern && ((IPattern)ast.get(i)).isDefault()) {
                        return true;
                    }
                    ++i;
                }
            }
        } else if (patternExpr instanceof IPattern) {
            return true;
        }
        return false;
    }

    private Map<IExpr, Pair<ISymbol, IExpr>> getEqualRules() {
        if (this.fEqualRules == null) {
            this.fEqualRules = new HashMap<IExpr, Pair<ISymbol, IExpr>>();
        }
        return this.fEqualRules;
    }

    private List<IPatternMatcher<IExpr>> getPatternRules() {
        if (this.fPatternRules == null) {
            this.fPatternRules = new ArrayList<IPatternMatcher<IExpr>>();
        }
        return this.fPatternRules;
    }

    private ArrayListMultimap<Integer, IPatternMatcher<IExpr>> getSimplePatternRules() {
        if (this.fSimplePatternRules == null) {
            this.fSimplePatternRules = ArrayListMultimap.create();
        }
        return this.fSimplePatternRules;
    }

    public List<IAST> definition() {
        IExpr condition;
        PatternMatcherAndEvaluator pmEvaluator;
        IAST ast;
        ISymbol setSymbol;
        ArrayList<IAST> definitionList = new ArrayList<IAST>();
        if (this.fEqualRules != null && this.fEqualRules.size() > 0) {
            for (IExpr key : this.fEqualRules.keySet()) {
                Pair<ISymbol, IExpr> pair = this.fEqualRules.get(key);
                setSymbol = pair.getFirst();
                ast = F.ast(setSymbol);
                ast.add(key);
                ast.add(pair.getSecond());
                definitionList.add(ast);
            }
        }
        if (this.fSimplePatternRules != null && this.fSimplePatternRules.size() > 0) {
            for (IPatternMatcher elem : this.fSimplePatternRules.values()) {
                if (!(elem instanceof PatternMatcherAndEvaluator)) continue;
                pmEvaluator = (PatternMatcherAndEvaluator)elem;
                setSymbol = pmEvaluator.getSetSymbol();
                ast = F.ast(setSymbol);
                ast.add(pmEvaluator.getLHS());
                condition = pmEvaluator.getCondition();
                if (condition != null) {
                    ast.add(F.Condition(pmEvaluator.getRHS(), condition));
                } else {
                    ast.add(pmEvaluator.getRHS());
                }
                definitionList.add(ast);
            }
        }
        if (this.fPatternRules != null && this.fPatternRules.size() > 0) {
            int i = 0;
            while (i < this.fPatternRules.size()) {
                if (this.fPatternRules.get(i) instanceof PatternMatcherAndEvaluator) {
                    pmEvaluator = (PatternMatcherAndEvaluator)this.fPatternRules.get(i);
                    setSymbol = pmEvaluator.getSetSymbol();
                    ast = F.ast(setSymbol);
                    ast.add(pmEvaluator.getLHS());
                    condition = pmEvaluator.getCondition();
                    if (condition != null) {
                        ast.add(F.Condition(pmEvaluator.getRHS(), condition));
                    } else {
                        ast.add(pmEvaluator.getRHS());
                    }
                    definitionList.add(ast);
                }
                ++i;
            }
        }
        return definitionList;
    }

    public void readSymbol(ObjectInputStream stream) throws IOException {
        IExpr condition;
        int condLength;
        PatternMatcherAndEvaluator pmEvaluator;
        IExpr rhs;
        ISymbol setSymbol;
        String astString;
        EvalEngine engine = EvalEngine.get();
        int len = stream.read();
        if (len > 0) {
            this.fEqualRules = new HashMap<IExpr, Pair<ISymbol, IExpr>>();
            int i = 0;
            while (i < len) {
                astString = stream.readUTF();
                setSymbol = F.symbol(astString);
                astString = stream.readUTF();
                IExpr key = engine.parse(astString);
                astString = stream.readUTF();
                IExpr value = engine.parse(astString);
                this.fEqualRules.put(key, new Pair<ISymbol, IExpr>(setSymbol, value));
                ++i;
            }
        }
        if ((len = stream.read()) > 0) {
            this.fSimplePatternRules = ArrayListMultimap.create();
            int i = 0;
            while (i < len) {
                astString = stream.readUTF();
                setSymbol = F.symbol(astString);
                astString = stream.readUTF();
                IExpr lhs = engine.parse(astString);
                astString = stream.readUTF();
                rhs = engine.parse(astString);
                pmEvaluator = new PatternMatcherAndEvaluator(setSymbol, lhs, rhs);
                condLength = stream.read();
                if (condLength == 0) {
                    condition = null;
                } else {
                    astString = stream.readUTF();
                    condition = engine.parse(astString);
                    pmEvaluator.setCondition(condition);
                }
                this.addSimplePatternRule(lhs, pmEvaluator);
                ++i;
            }
        }
        if ((len = stream.read()) > 0) {
            this.fPatternRules = new ArrayList<IPatternMatcher<IExpr>>();
            int listLength = stream.read();
            int j = 0;
            while (j < listLength) {
                astString = stream.readUTF();
                setSymbol = F.symbol(astString);
                astString = stream.readUTF();
                IExpr lhs = engine.parse(astString);
                astString = stream.readUTF();
                rhs = engine.parse(astString);
                pmEvaluator = new PatternMatcherAndEvaluator(setSymbol, lhs, rhs);
                condLength = stream.read();
                if (condLength == 0) {
                    condition = null;
                } else {
                    astString = stream.readUTF();
                    condition = engine.parse(astString);
                    pmEvaluator.setCondition(condition);
                }
                this.addSimplePatternRule(lhs, pmEvaluator);
                ++j;
            }
        }
    }

    public void writeSymbol(ObjectOutputStream stream) throws IOException {
        IExpr condition;
        ISymbol setSymbol;
        PatternMatcherAndEvaluator pmEvaluator;
        if (this.fEqualRules == null || this.fEqualRules.size() == 0) {
            stream.write(0);
        } else {
            stream.write(this.fEqualRules.size());
            for (IExpr key : this.fEqualRules.keySet()) {
                Pair<ISymbol, IExpr> pair = this.fEqualRules.get(key);
                stream.writeUTF(pair.getFirst().toString());
                stream.writeUTF(key.fullFormString());
                stream.writeUTF(pair.getSecond().fullFormString());
            }
        }
        if (this.fSimplePatternRules == null || this.fSimplePatternRules.size() == 0) {
            stream.write(0);
        } else {
            stream.write(this.fSimplePatternRules.size());
            for (IPatternMatcher elem : this.fSimplePatternRules.values()) {
                pmEvaluator = (PatternMatcherAndEvaluator)elem;
                setSymbol = pmEvaluator.getSetSymbol();
                stream.writeUTF(setSymbol.toString());
                stream.writeUTF(pmEvaluator.getLHS().fullFormString());
                stream.writeUTF(pmEvaluator.getRHS().fullFormString());
                condition = pmEvaluator.getCondition();
                if (condition == null) {
                    stream.write(0);
                    continue;
                }
                stream.write(1);
                stream.writeUTF(condition.fullFormString());
            }
        }
        if (this.fPatternRules == null || this.fPatternRules.size() == 0) {
            stream.write(0);
        } else {
            stream.write(this.fPatternRules.size());
            int i = 0;
            while (i < this.fPatternRules.size()) {
                pmEvaluator = (PatternMatcherAndEvaluator)this.fPatternRules.get(i);
                setSymbol = pmEvaluator.getSetSymbol();
                stream.writeUTF(setSymbol.toString());
                stream.writeUTF(pmEvaluator.getLHS().fullFormString());
                stream.writeUTF(pmEvaluator.getRHS().fullFormString());
                condition = pmEvaluator.getCondition();
                if (condition == null) {
                    stream.write(0);
                } else {
                    stream.write(1);
                    stream.writeUTF(condition.fullFormString());
                }
                ++i;
            }
        }
    }
}

