/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.polynomials;

import java.util.Comparator;
import java.util.TreeMap;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.ISignedNumber;
import org.matheclipse.core.interfaces.ISymbol;

public class HornerScheme {
    private TreeMap<ISignedNumber, IAST> map;

    public HornerScheme() {
        Comparator<ISignedNumber> comp = new Comparator<ISignedNumber>(){

            @Override
            public int compare(ISignedNumber arg0, ISignedNumber arg1) {
                if (arg0.isGreaterThan(arg1)) {
                    return 1;
                }
                if (arg0.isLessThan(arg1)) {
                    return -1;
                }
                return 0;
            }
        };
        this.map = new TreeMap(comp);
    }

    public IAST generate(boolean numericMode, IAST poly, ISymbol sym) {
        IAST result;
        if (numericMode) {
            IAST result2;
            int i = 1;
            while (i < poly.size()) {
                this.collectTermN(sym, (IExpr)poly.get(i));
                ++i;
            }
            IAST startResult = result2 = F.Plus();
            ISignedNumber start = F.CD0;
            for (ISignedNumber exponent : this.map.keySet()) {
                IExpr coefficient = this.getCoefficient(exponent);
                if (exponent.isLessThan(F.CD1)) {
                    if (exponent.compareTo(F.CD0) == 0) {
                        result2.add(coefficient);
                        continue;
                    }
                    result2.add(F.Times(coefficient, (IExpr)F.Power((IExpr)sym, exponent)));
                    continue;
                }
                IAST temp = F.Times();
                ISignedNumber currentExponent = exponent.minus(start);
                if (currentExponent.equals(F.CD1)) {
                    temp.add(sym);
                } else {
                    temp.add(F.Power((IExpr)sym, currentExponent));
                }
                result2.add(temp);
                result2 = F.Plus();
                temp.add(result2);
                result2.add(coefficient);
                start = exponent;
            }
            return startResult;
        }
        int i = 1;
        while (i < poly.size()) {
            this.collectTerm(sym, (IExpr)poly.get(i));
            ++i;
        }
        IAST startResult = result = F.Plus();
        ISignedNumber start = F.C0;
        for (ISignedNumber exponent : this.map.keySet()) {
            IExpr coefficient = this.getCoefficient(exponent);
            if (exponent.isLessThan(F.C1)) {
                if (exponent.compareTo(F.C0) == 0) {
                    result.add(coefficient);
                    continue;
                }
                result.add(F.Times(coefficient, (IExpr)F.Power((IExpr)sym, exponent)));
                continue;
            }
            IAST temp = F.Times();
            ISignedNumber currentExponent = exponent.minus(start);
            if (currentExponent.equals(F.C1)) {
                temp.add(sym);
            } else {
                temp.add(F.Power((IExpr)sym, currentExponent));
            }
            result.add(temp);
            result = F.Plus();
            temp.add(result);
            result.add(coefficient);
            start = exponent;
        }
        return startResult;
    }

    private IExpr getCoefficient(ISignedNumber key) {
        IExpr coefficient;
        IAST value = this.map.get(key);
        if (value.isAST(F.Plus, 2)) {
            coefficient = (IExpr)value.get(1);
            if (coefficient.isAST(F.Times, 2)) {
                coefficient = (IExpr)((IAST)coefficient).get(1);
            }
        } else {
            coefficient = value;
        }
        return coefficient;
    }

    private void collectTerm(ISymbol sym, IExpr expr) {
        if (expr instanceof IAST) {
            IAST term = (IAST)expr;
            if (term.isASTSizeGE(F.Times, 2)) {
                int i = 1;
                while (i < term.size()) {
                    IAST pow;
                    if (sym.equals(term.get(i))) {
                        IAST temp = F.ast(term, F.Times, false, i, i + 1);
                        this.addToMap(F.C1, temp);
                        return;
                    }
                    if (((IExpr)term.get(i)).isAST(F.Power, 3) && ((IExpr)(pow = (IAST)term.get(i)).get(1)).equals(sym) && pow.get(2) instanceof ISignedNumber) {
                        IAST temp = F.ast(term, F.Times, false, i, i + 1);
                        this.addToMap((ISignedNumber)pow.get(2), temp);
                        return;
                    }
                    ++i;
                }
            } else if (term.isAST(F.Power, 3) && ((IExpr)term.get(1)).equals(sym) && term.get(2) instanceof ISignedNumber) {
                this.addToMap((ISignedNumber)term.get(2), F.C1);
                return;
            }
        } else if (expr instanceof ISymbol && expr.equals(sym)) {
            this.addToMap(F.C1, F.C1);
            return;
        }
        this.addToMap(F.C0, expr);
    }

    private void collectTermN(ISymbol sym, IExpr expr) {
        if (expr instanceof IAST) {
            IAST term = (IAST)expr;
            if (term.isASTSizeGE(F.Times, 2)) {
                int i = 1;
                while (i < term.size()) {
                    IAST pow;
                    if (sym.equals(term.get(i))) {
                        IAST temp = F.ast(term, F.Times, false, i, i + 1);
                        this.addToMap(F.CD1, temp);
                        return;
                    }
                    if (((IExpr)term.get(i)).isAST(F.Power, 3) && ((IExpr)(pow = (IAST)term.get(i)).get(1)).equals(sym) && pow.get(2) instanceof ISignedNumber) {
                        IAST temp = F.ast(term, F.Times, false, i, i + 1);
                        this.addToMap((ISignedNumber)pow.get(2), temp);
                        return;
                    }
                    ++i;
                }
            } else if (term.isAST(F.Power, 3) && ((IExpr)term.get(1)).equals(sym) && term.get(2) instanceof ISignedNumber) {
                this.addToMap((ISignedNumber)term.get(2), F.CD1);
                return;
            }
        } else if (expr instanceof ISymbol && expr.equals(sym)) {
            this.addToMap(F.CD1, F.CD1);
            return;
        }
        this.addToMap(F.CD0, expr);
    }

    public IAST addToMap(ISignedNumber key, IExpr value) {
        IAST temp = this.map.get(key);
        if (temp == null) {
            temp = F.Plus();
            temp.add(value);
            this.map.put(key, temp);
        } else {
            temp.add(value);
        }
        return temp;
    }
}

