/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.reflection.system;

import edu.jas.arith.BigRational;
import edu.jas.poly.GenPolynomial;
import edu.jas.ufd.FactorAbstract;
import edu.jas.ufd.FactorFactory;
import edu.jas.ufd.SquarefreeAbstract;
import edu.jas.ufd.SquarefreeFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.SortedMap;
import org.matheclipse.core.convert.ExprVariables;
import org.matheclipse.core.convert.JASConvert;
import org.matheclipse.core.eval.exception.Validate;
import org.matheclipse.core.eval.interfaces.AbstractFunctionEvaluator;
import org.matheclipse.core.expression.ASTRange;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.IRational;
import org.matheclipse.core.interfaces.ISignedNumber;

public class Apart
extends AbstractFunctionEvaluator {
    @Override
    public IExpr evaluate(IAST ast) {
        Validate.checkSize(ast, 2);
        ExprVariables eVar = new ExprVariables((IExpr)ast.get(1));
        if (!eVar.isSize(1)) {
            return null;
        }
        IAST variableList = eVar.getVarList();
        IExpr header = ((IExpr)ast.get(1)).head();
        if (header == F.Times || header == F.Power) {
            IAST plusResult;
            IExpr[] parts = Apart.getFractionalParts((IExpr)ast.get(1));
            if (parts != null && (plusResult = Apart.apart(parts, variableList)) != null) {
                if (plusResult.size() == 2) {
                    return (IExpr)plusResult.get(1);
                }
                return plusResult;
            }
        } else {
            return (IExpr)ast.get(1);
        }
        return null;
    }

    public static IAST apart(IExpr[] parts, IAST variableList) {
        try {
            IExpr exprNumerator = F.evalExpandAll(parts[0]);
            IExpr exprDenominator = F.evalExpandAll(parts[1]);
            ASTRange r = new ASTRange(variableList, 1);
            List<IExpr> varList = r.toList();
            String[] varListStr = new String[]{((IExpr)variableList.get(1)).toString()};
            JASConvert<BigRational> jas = new JASConvert<BigRational>(varList, BigRational.ZERO);
            GenPolynomial<BigRational> numerator = jas.expr2Poly(exprNumerator);
            GenPolynomial<BigRational> denominator = jas.expr2Poly(exprDenominator);
            FactorAbstract<BigRational> factorAbstract = FactorFactory.getImplementation(BigRational.ZERO);
            SortedMap sfactors = factorAbstract.baseFactors(denominator);
            ArrayList<GenPolynomial<BigRational>> D2 = new ArrayList<GenPolynomial<BigRational>>(sfactors.keySet());
            SquarefreeAbstract<BigRational> sqf = SquarefreeFactory.getImplementation(BigRational.ZERO);
            List<List<GenPolynomial<BigRational>>> Ai = sqf.basePartialFraction(numerator, sfactors);
            if (Ai.size() > 0) {
                IExpr temp;
                IAST result = F.Plus();
                if (!Ai.get(0).get(0).isZERO()) {
                    temp = F.eval(jas.poly2Expr(Ai.get(0).get(0), null));
                    if (temp instanceof IAST) {
                        ((IAST)temp).addEvalFlags(128);
                    }
                    result.add(temp);
                }
                int i = 1;
                while (i < Ai.size()) {
                    List<GenPolynomial<BigRational>> list = Ai.get(i);
                    long j = 0L;
                    for (GenPolynomial<BigRational> genPolynomial : list) {
                        if (!genPolynomial.isZERO() && !(temp = F.eval(F.Times((IExpr)jas.poly2Expr(genPolynomial, null), (IExpr)F.Power((IExpr)jas.poly2Expr((GenPolynomial)D2.get(i - 1), null), F.integer(j * -1L))))).equals(F.C0)) {
                            if (temp instanceof IAST) {
                                ((IAST)temp).addEvalFlags(128);
                            }
                            result.add(temp);
                        }
                        ++j;
                    }
                    ++i;
                }
                return result;
            }
        }
        catch (ClassCastException exprNumerator) {
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public static IExpr[] getFractionalParts(IExpr arg) {
        IExpr[] parts = null;
        if (arg.isTimes()) {
            parts = Apart.getFractionalPartsTimes((IAST)arg, true);
        } else if (arg.isPower()) {
            IAST temp = (IAST)arg;
            if (temp.get(2) instanceof ISignedNumber) {
                parts = new IExpr[2];
                if (((IExpr)temp.get(2)).equals(F.CN1)) {
                    parts[0] = F.C1;
                    parts[1] = (IExpr)temp.get(1);
                } else if (((ISignedNumber)temp.get(2)).isNegative()) {
                    parts[0] = F.C1;
                    parts[1] = F.Power((IExpr)temp.get(1), ((ISignedNumber)temp.get(2)).negate());
                } else {
                    parts[0] = arg;
                    parts[1] = F.C1;
                }
            }
        } else {
            parts = new IExpr[]{arg, F.C1};
        }
        return parts;
    }

    /*
     * Unable to fully structure code
     */
    public static IExpr[] getFractionalPartsTimes(IAST ast, boolean splitFractionalNumbers) {
        result = new IExpr[2];
        numerator = F.Times();
        denominator = F.Times();
        i = 1;
        while (i < ast.size()) {
            block7: {
                block5: {
                    block4: {
                        block6: {
                            arg = (IExpr)ast.get(i);
                            if (!arg.isAST(F.Power, 3)) break block4;
                            temp = (IAST)arg;
                            if (!(temp.get(2) instanceof ISignedNumber)) break block5;
                            if (!((IExpr)temp.get(2)).equals(F.CN1)) break block6;
                            denominator.add((IExpr)temp.get(1));
                            break block7;
                        }
                        if (!((ISignedNumber)temp.get(2)).isNegative()) break block5;
                        denominator.add(F.Power((IExpr)temp.get(1), ((ISignedNumber)temp.get(2)).negate()));
                        break block7;
                    }
                    if (splitFractionalNumbers && arg instanceof IRational) {
                        numer = ((IRational)arg).getNumerator();
                        if (!numer.equals(F.C1)) {
                            numerator.add(numer);
                        }
                        if (!(denom = ((IRational)arg).getDenominator()).equals(F.C1)) {
                            denominator.add(denom);
                            ** GOTO lbl34
                        } else {
                            ** GOTO lbl30
                        }
                    }
                    break block5;
lbl30:
                    // 2 sources

                    break block7;
                }
                numerator.add(arg);
            }
            ++i;
        }
        result[0] = numerator.size() == 1 ? F.C1 : (numerator.size() == 2 ? (IExpr)numerator.get(1) : numerator);
        result[1] = denominator.size() == 1 ? F.C1 : (denominator.size() == 2 ? (IExpr)denominator.get(1) : denominator);
        return result;
    }
}

