/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.reflection.system;

import apache.harmony.math.Rational;
import org.matheclipse.core.eval.interfaces.AbstractTrigArg1;
import org.matheclipse.core.eval.interfaces.INumeric;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.expression.Num;
import org.matheclipse.core.interfaces.IComplex;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.ISignedNumber;
import org.matheclipse.core.interfaces.ISymbol;
import org.matheclipse.parser.client.SyntaxError;

public class Arg
extends AbstractTrigArg1
implements INumeric {
    @Override
    public IExpr evaluateArg1(IExpr arg1) {
        IComplex ic;
        if (arg1 instanceof ISignedNumber) {
            ISignedNumber in = (ISignedNumber)arg1;
            if (in.isNegative()) {
                return F.Pi;
            }
            if (!in.equals(F.C0)) {
                return F.C0;
            }
        } else if (arg1 instanceof IComplex && (ic = (IComplex)arg1).getRealPart().equals(Rational.ZERO)) {
            Rational imaginaryPart = ic.getImaginaryPart();
            if (Rational.ZERO.isLargerThan(imaginaryPart)) {
                return F.Times((IExpr)F.CN1D2, (IExpr)F.Pi);
            }
            if (imaginaryPart.isLargerThan(Rational.ZERO)) {
                return F.Times((IExpr)F.C1D2, (IExpr)F.Pi);
            }
        }
        return null;
    }

    @Override
    public IExpr numericEvalD1(Num arg1) {
        double d = arg1.getRealPart();
        if (d < 0.0) {
            return F.num(Math.PI);
        }
        if (d > 0.0) {
            return F.CD0;
        }
        return null;
    }

    @Override
    public double evalReal(double[] stack, int top, int size) {
        if (size != 1) {
            throw new UnsupportedOperationException();
        }
        if (stack[top] < 0.0) {
            return Math.PI;
        }
        if (stack[top] > 0.0) {
            return 0.0;
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public void setUp(ISymbol symbol) throws SyntaxError {
        symbol.setAttributes(1152);
        super.setUp(symbol);
    }
}

