/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.reflection.system;

import java.util.ArrayList;
import org.matheclipse.core.eval.EvalEngine;
import org.matheclipse.core.eval.exception.Validate;
import org.matheclipse.core.eval.interfaces.IFunctionEvaluator;
import org.matheclipse.core.expression.AST;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.generic.MultipleArrayFunction;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.IInteger;
import org.matheclipse.core.interfaces.ISymbol;
import org.matheclipse.generic.interfaces.IIterator;
import org.matheclipse.generic.nested.TableGenerator;

public class Array
implements IFunctionEvaluator {
    @Override
    public IExpr evaluate(IAST ast) {
        return Array.evaluateArray(ast, F.List());
    }

    public static IExpr evaluateArray(IAST ast, IAST resultList) {
        block15: {
            try {
                IAST dimIter;
                if (ast.size() < 3 || ast.size() > 5) break block15;
                EvalEngine engine = EvalEngine.get();
                ArrayList<ArrayIterator> iterList = new ArrayList<ArrayIterator>();
                if (ast.size() == 3 && ast.get(2) instanceof IInteger) {
                    int indx1 = Validate.checkIntType(ast, 2);
                    iterList.add(new ArrayIterator(indx1));
                } else if (ast.size() == 3 && ((IExpr)ast.get(2)).isList()) {
                    dimIter = (IAST)ast.get(2);
                    int i = 1;
                    while (i < dimIter.size()) {
                        int indx1 = Validate.checkIntType(dimIter, i);
                        iterList.add(new ArrayIterator(indx1));
                        ++i;
                    }
                } else if (ast.size() >= 4) {
                    if (ast.get(2) instanceof IInteger && ast.get(3) instanceof IInteger) {
                        int indx1 = Validate.checkIntType(ast, 3);
                        int indx2 = Validate.checkIntType(ast, 2);
                        iterList.add(new ArrayIterator(indx1, indx2));
                    } else if (((IExpr)ast.get(2)).isList() && ((IExpr)ast.get(3)).isList()) {
                        dimIter = (IAST)ast.get(2);
                        IAST originIter = (IAST)ast.get(3);
                        int i = 1;
                        while (i < dimIter.size()) {
                            int indx1 = Validate.checkIntType(originIter, i);
                            int indx2 = Validate.checkIntType(dimIter, i);
                            iterList.add(new ArrayIterator(indx1, indx2));
                            ++i;
                        }
                    }
                }
                if (iterList.size() > 0) {
                    if (ast.size() == 5) {
                        resultList = F.ast((IExpr)ast.get(4));
                    }
                    IAST list = F.ast((IExpr)ast.get(1));
                    TableGenerator<IExpr, IAST> generator = new TableGenerator<IExpr, IAST>(iterList, resultList, new MultipleArrayFunction(engine, list), AST.COPY);
                    return generator.table();
                }
            }
            catch (ClassCastException classCastException) {
            }
            catch (ArithmeticException arithmeticException) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public IExpr numericEval(IAST functionList) {
        return this.evaluate(functionList);
    }

    @Override
    public void setUp(ISymbol symbol) {
        symbol.setAttributes(96);
    }

    public static class ArrayIterator
    implements IIterator<IExpr> {
        int fCurrent;
        final int fFrom;
        final int fTo;

        public ArrayIterator(int to) {
            this(1, to);
        }

        public ArrayIterator(int from, int length) {
            this.fFrom = from;
            this.fCurrent = from;
            this.fTo = from + length - 1;
        }

        @Override
        public boolean setUp() {
            return true;
        }

        @Override
        public void tearDown() {
            this.fCurrent = this.fFrom;
        }

        @Override
        public boolean hasNext() {
            return this.fCurrent <= this.fTo;
        }

        @Override
        public IExpr next() {
            return F.integer(this.fCurrent++);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

