/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.reflection.system;

import apache.harmony.math.BigInteger;
import org.matheclipse.core.eval.interfaces.AbstractArg2;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.IInteger;

public class Binomial
extends AbstractArg2 {
    @Override
    public IExpr e2IntArg(IInteger n0, IInteger k0) {
        BigInteger n = n0.getBigNumerator();
        BigInteger k = k0.getBigNumerator();
        return F.integer(this.binomial(n, k));
    }

    private BigInteger binomial(BigInteger n, BigInteger k) {
        if (k.isLargerThan(n)) {
            return BigInteger.ZERO;
        }
        if (k.isZero() || k.equals(n)) {
            return BigInteger.ONE;
        }
        BigInteger bin = BigInteger.ONE;
        BigInteger i = BigInteger.ONE;
        while (!i.isLargerThan(k)) {
            bin = bin.times(n.minus(i).plus(BigInteger.ONE)).divide(i);
            i = i.plus(BigInteger.ONE);
        }
        return bin;
    }
}

