/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.reflection.system;

import org.matheclipse.core.eval.exception.WrongNumberOfArguments;
import org.matheclipse.core.eval.interfaces.IFunctionEvaluator;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.ISymbol;

public class ChessboardDistance
implements IFunctionEvaluator {
    @Override
    public IExpr evaluate(IAST functionList) {
        int dim2;
        if (functionList.size() != 3) {
            throw new WrongNumberOfArguments(functionList, 2, functionList.size() - 1);
        }
        IExpr arg1 = (IExpr)functionList.get(1);
        IExpr arg2 = (IExpr)functionList.get(2);
        int dim1 = arg1.isVector();
        if (dim1 > -1 && dim1 == (dim2 = arg2.isVector())) {
            if (dim1 == 0) {
                return F.C0;
            }
            IAST a1 = (IAST)arg1;
            IAST a2 = (IAST)arg2;
            IAST maxAST = F.Max();
            int i = 1;
            while (i < a1.size()) {
                maxAST.add(F.Abs(F.Subtract((IExpr)a1.get(i), (IExpr)a2.get(i))));
                ++i;
            }
            return maxAST;
        }
        return null;
    }

    @Override
    public IExpr numericEval(IAST functionList) {
        return this.evaluate(functionList);
    }

    @Override
    public void setUp(ISymbol symbol) {
    }
}

