/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.reflection.system;

import apache.harmony.math.BigInteger;
import org.matheclipse.core.eval.exception.WrongNumberOfArguments;
import org.matheclipse.core.eval.interfaces.IFunctionEvaluator;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.IFraction;
import org.matheclipse.core.interfaces.INum;
import org.matheclipse.core.interfaces.IRational;
import org.matheclipse.core.interfaces.ISymbol;

public class ContinuedFraction
implements IFunctionEvaluator {
    @Override
    public IExpr evaluate(IAST functionList) {
        if (functionList.size() != 2) {
            throw new WrongNumberOfArguments(functionList, 1, functionList.size() - 1);
        }
        IExpr arg1 = (IExpr)functionList.get(1);
        if (arg1 instanceof INum) {
            arg1 = F.fraction(((INum)arg1).getRealPart());
        }
        if (arg1 instanceof IRational) {
            IRational rat = (IRational)arg1;
            IAST continuedFractionList = F.List();
            if (rat.getDenominator().equals(F.C1)) {
                continuedFractionList.add(rat.getNumerator());
            } else if (rat.getNumerator().equals(F.C1)) {
                continuedFractionList.add(F.C0);
                continuedFractionList.add(rat.getDenominator());
            } else {
                IFraction temp = F.fraction(rat.getNumerator(), rat.getDenominator());
                while (temp.getDenominator().isGreaterThan(F.C1)) {
                    BigInteger quotient = temp.getBigNumerator().divide(temp.getBigDenominator());
                    BigInteger remainder = temp.getBigNumerator().mod(temp.getBigDenominator());
                    continuedFractionList.add(F.integer(quotient));
                    temp = F.fraction(temp.getBigDenominator(), remainder);
                    if (!temp.getDenominator().equals(F.C1)) continue;
                    continuedFractionList.add(temp.getNumerator());
                }
            }
            return continuedFractionList;
        }
        return null;
    }

    @Override
    public IExpr numericEval(IAST functionList) {
        return this.evaluate(functionList);
    }

    @Override
    public void setUp(ISymbol symbol) {
    }
}

