/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.reflection.system;

import java.util.ArrayList;
import org.matheclipse.core.eval.interfaces.AbstractFunctionEvaluator;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.ISymbol;

public class Dimensions
extends AbstractFunctionEvaluator {
    @Override
    public IExpr evaluate(IAST ast) {
        if (ast.size() == 2 && ast.get(1) instanceof IAST) {
            IAST list = (IAST)ast.get(1);
            int m = list.size();
            ArrayList<Integer> dims = new ArrayList<Integer>();
            IAST res = F.List();
            ISymbol header = list.topHead();
            dims.add(m - 1);
            this.getLevel1(list, header, dims);
            this.checkLevel(list, header, dims, 1);
            int i = 0;
            while (i < dims.size()) {
                res.add(F.integer(dims.get(i).intValue()));
                ++i;
            }
            return res;
        }
        return F.List();
    }

    private void getLevel1(IAST ast, ISymbol header, ArrayList<Integer> dims) {
        if (ast.size() > 1 && ast.get(1) instanceof IAST) {
            IAST list = (IAST)ast.get(1);
            if (!header.equals(list.topHead())) {
                return;
            }
            dims.add(list.size() - 1);
            this.getLevel1(list, header, dims);
        }
    }

    private void checkLevel(IAST ast, ISymbol header, ArrayList<Integer> dims, int index) {
        if (ast.size() > 1 && index < dims.size()) {
            int dim = dims.get(index);
            int i = 1;
            while (i < ast.size()) {
                if (ast.get(i) instanceof IAST) {
                    IAST list = (IAST)ast.get(i);
                    if (!header.equals(list.topHead()) || dim != list.size() - 1) {
                        while (index < dims.size()) {
                            dims.remove(index);
                        }
                        return;
                    }
                    this.checkLevel(list, header, dims, index + 1);
                }
                ++i;
            }
        }
    }

    @Override
    public void setUp(ISymbol symbol) {
    }
}

