/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.reflection.system;

import org.apache.commons.math.linear.EigenDecompositionImpl;
import org.apache.commons.math.linear.FieldMatrix;
import org.apache.commons.math.linear.InvalidMatrixException;
import org.apache.commons.math.linear.RealMatrix;
import org.apache.commons.math.linear.RealVector;
import org.matheclipse.core.convert.Convert;
import org.matheclipse.core.eval.exception.WrappedException;
import org.matheclipse.core.eval.interfaces.AbstractMatrix1Expr;
import org.matheclipse.core.expression.ExprFieldElement;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IExpr;

public class Eigenvectors
extends AbstractMatrix1Expr {
    @Override
    public IExpr evaluate(IAST function) {
        return this.numericEval(function);
    }

    @Override
    public IAST realMatrixEval(RealMatrix matrix) {
        try {
            IAST list = F.List();
            EigenDecompositionImpl ed = new EigenDecompositionImpl(matrix, Double.MIN_NORMAL);
            int i = 0;
            while (i < matrix.getColumnDimension()) {
                RealVector rv = ed.getEigenvector(i);
                list.add(Convert.realVector2List(rv));
                ++i;
            }
            return list;
        }
        catch (InvalidMatrixException ime) {
            throw new WrappedException(ime);
        }
    }

    @Override
    public ExprFieldElement matrixEval(FieldMatrix<ExprFieldElement> matrix) {
        return null;
    }
}

