/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.reflection.system;

import apache.harmony.math.BigInteger;
import org.matheclipse.core.eval.interfaces.AbstractFunctionEvaluator;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.IInteger;

public class ExtendedGCD
extends AbstractFunctionEvaluator {
    @Override
    public IExpr evaluate(IAST functionList) {
        if (functionList.size() < 3) {
            return null;
        }
        int i = 1;
        while (i < functionList.size()) {
            if (!((IExpr)functionList.get(i)).isInteger()) {
                return null;
            }
            if (!((IInteger)functionList.get(i)).isPositive()) {
                return null;
            }
            ++i;
        }
        try {
            BigInteger gcd = ((IInteger)functionList.get(1)).getBigNumerator();
            BigInteger factor = BigInteger.ONE;
            BigInteger[] subBezouts = new BigInteger[functionList.size() - 1];
            Object[] stepResult = ExtendedGCD.extendedGCD(((IInteger)functionList.get(2)).getBigNumerator(), gcd);
            gcd = (BigInteger)stepResult[0];
            subBezouts[0] = ((BigInteger[])stepResult[1])[0];
            subBezouts[1] = ((BigInteger[])stepResult[1])[1];
            int i2 = 3;
            while (i2 < functionList.size()) {
                stepResult = ExtendedGCD.extendedGCD(((IInteger)functionList.get(i2)).getBigNumerator(), gcd);
                gcd = (BigInteger)stepResult[0];
                factor = ((BigInteger[])stepResult[1])[0];
                int j = 0;
                while (j < i2 - 1) {
                    subBezouts[j] = subBezouts[j].multiply(factor);
                    ++j;
                }
                subBezouts[i2 - 1] = ((BigInteger[])stepResult[1])[1];
                ++i2;
            }
            IAST subList = F.List();
            int i3 = 0;
            while (i3 < subBezouts.length) {
                subList.add(F.integer(subBezouts[i3]));
                ++i3;
            }
            IAST list = F.List();
            list.add(F.integer(gcd));
            list.add(subList);
            return list;
        }
        catch (ArithmeticException ae) {
            ae.printStackTrace();
            return null;
        }
    }

    public static Object[] extendedGCD(BigInteger numberOne, BigInteger numberTwo) throws ArithmeticException {
        Object[] results = new Object[2];
        BigInteger[] divisionResult = new BigInteger[2];
        BigInteger gcd = BigInteger.ONE;
        BigInteger mValue = BigInteger.ONE;
        BigInteger nValue = BigInteger.ONE;
        BigInteger remainder = BigInteger.ONE;
        BigInteger xValue = BigInteger.ZERO;
        BigInteger lastxValue = BigInteger.ONE;
        BigInteger yValue = BigInteger.ONE;
        BigInteger lastyValue = BigInteger.ZERO;
        if (numberOne.compareTo(BigInteger.ZERO) != 0 && numberTwo.compareTo(BigInteger.ZERO) != 0 && numberOne.compareTo(BigInteger.ZERO) == 1 && numberTwo.compareTo(BigInteger.ZERO) == 1) {
            BigInteger divisor;
            BigInteger dividend;
            boolean exchange;
            if (numberOne.compareTo(numberTwo) == 1) {
                exchange = false;
                dividend = numberOne;
                divisor = numberTwo;
            } else {
                exchange = true;
                dividend = numberTwo;
                divisor = numberOne;
            }
            while (remainder.compareTo(BigInteger.ZERO) != 0) {
                divisionResult = dividend.divideAndRemainder(divisor);
                BigInteger quotient = divisionResult[0];
                remainder = divisionResult[1];
                dividend = divisor;
                divisor = remainder;
                BigInteger tempValue = xValue;
                xValue = lastxValue.subtract(quotient.multiply(xValue));
                lastxValue = tempValue;
                tempValue = yValue;
                yValue = lastyValue.subtract(quotient.multiply(yValue));
                lastyValue = tempValue;
            }
            gcd = dividend;
            if (exchange) {
                mValue = lastyValue;
                nValue = lastxValue;
            } else {
                mValue = lastxValue;
                nValue = lastyValue;
            }
        } else {
            throw new ArithmeticException("ExtendedGCD contains wrong arguments");
        }
        results[0] = gcd;
        BigInteger[] values = new BigInteger[]{nValue, mValue};
        results[1] = values;
        return results;
    }
}

