/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.reflection.system;

import edu.jas.arith.BigInteger;
import edu.jas.arith.BigRational;
import edu.jas.arith.ModInteger;
import edu.jas.arith.ModIntegerRing;
import edu.jas.poly.GenPolynomial;
import edu.jas.ufd.FactorAbstract;
import edu.jas.ufd.FactorFactory;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import org.matheclipse.core.convert.ExprVariables;
import org.matheclipse.core.convert.JASConvert;
import org.matheclipse.core.eval.exception.WrongArgumentType;
import org.matheclipse.core.eval.interfaces.AbstractFunctionEvaluator;
import org.matheclipse.core.eval.util.Options;
import org.matheclipse.core.expression.ASTRange;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.IInteger;

public class Factor
extends AbstractFunctionEvaluator {
    @Override
    public IExpr evaluate(IAST ast) {
        if (ast.size() != 2 && ast.size() != 3) {
            return null;
        }
        ExprVariables eVar = new ExprVariables((IExpr)ast.get(1));
        if (!eVar.isSize(1)) {
            throw new WrongArgumentType(ast, (IExpr)ast.get(1), 1, "Factorization only implemented for univariate polynomials");
        }
        try {
            IExpr expr = F.evalExpandAll((IExpr)ast.get(1));
            ASTRange r = new ASTRange(eVar.getVarList(), 1);
            List<IExpr> varList = r.toList();
            if (ast.size() == 3) {
                return Factor.factorWithOption(ast, expr, varList, false);
            }
            return Factor.factor(expr, varList, false);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static IExpr factor(IExpr expr, List<IExpr> varList, boolean factorSquareFree) {
        JASConvert<BigRational> jas = new JASConvert<BigRational>(varList, BigRational.ZERO);
        GenPolynomial<BigRational> polyRat = jas.expr2Poly(expr);
        Object[] objects = jas.factorTerms(polyRat);
        java.math.BigInteger gcd = (java.math.BigInteger)objects[0];
        java.math.BigInteger lcm = (java.math.BigInteger)objects[1];
        GenPolynomial poly = (GenPolynomial)objects[2];
        FactorAbstract<BigInteger> factorAbstract = FactorFactory.getImplementation(BigInteger.ONE);
        SortedMap<GenPolynomial<BigInteger>, Long> map = factorSquareFree ? factorAbstract.squarefreeFactors(poly) : factorAbstract.factors(poly);
        IAST result = F.Times();
        if (!gcd.equals(java.math.BigInteger.ONE) || !lcm.equals(java.math.BigInteger.ONE)) {
            result.add(F.fraction(gcd, lcm));
        }
        for (Map.Entry<GenPolynomial<BigInteger>, Long> entry : map.entrySet()) {
            result.add(F.Power((IExpr)jas.integerPoly2Expr(entry.getKey()), F.integer(entry.getValue())));
        }
        return result;
    }

    public static IExpr factorWithOption(IAST lst, IExpr expr, List<IExpr> varList, boolean factorSquareFree) {
        Options options = new Options(lst.topHead(), lst, 2);
        IExpr option = options.getOption("Modulus");
        if (option != null && option instanceof IInteger) {
            try {
                apache.harmony.math.BigInteger value = ((IInteger)option).getBigNumerator();
                int intValue = ((IInteger)option).toInt();
                ModIntegerRing modIntegerRing = new ModIntegerRing(intValue, value.isProbablePrime(32));
                JASConvert<ModInteger> jas = new JASConvert<ModInteger>(varList, modIntegerRing);
                GenPolynomial<ModInteger> poly = jas.expr2Poly(expr);
                FactorAbstract<ModInteger> factorAbstract = FactorFactory.getImplementation(modIntegerRing);
                SortedMap<GenPolynomial<ModInteger>, Long> map = factorSquareFree ? factorAbstract.squarefreeFactors(poly) : factorAbstract.factors(poly);
                IAST result = F.Times();
                for (Map.Entry<GenPolynomial<ModInteger>, Long> entry : map.entrySet()) {
                    GenPolynomial<ModInteger> singleFactor = entry.getKey();
                    Long val = entry.getValue();
                    result.add(F.Power((IExpr)jas.modIntegerPoly2Expr(singleFactor), F.integer(val)));
                }
                return result;
            }
            catch (ArithmeticException arithmeticException) {
                // empty catch block
            }
        }
        return null;
    }
}

