/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.reflection.system;

import java.util.List;
import org.matheclipse.core.convert.ExprVariables;
import org.matheclipse.core.eval.exception.WrongArgumentType;
import org.matheclipse.core.expression.ASTRange;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.reflection.system.Factor;

public class FactorSquareFree
extends Factor {
    @Override
    public IExpr evaluate(IAST lst) {
        if (lst.size() != 2 && lst.size() != 3) {
            return null;
        }
        ExprVariables eVar = new ExprVariables((IExpr)lst.get(1));
        if (!eVar.isSize(1)) {
            throw new WrongArgumentType(lst, (IExpr)lst.get(1), 1, "Factorization only implemented for univariate polynomials");
        }
        try {
            IExpr expr = F.evalExpandAll((IExpr)lst.get(1));
            ASTRange r = new ASTRange(eVar.getVarList(), 1);
            List<IExpr> varList = r.toList();
            if (lst.size() == 3) {
                return FactorSquareFree.factorWithOption(lst, expr, varList, true);
            }
            return FactorSquareFree.factor(expr, varList, true);
        }
        catch (Exception exception) {
            return null;
        }
    }
}

