/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.reflection.system;

import edu.jas.arith.BigRational;
import edu.jas.poly.GenPolynomial;
import java.math.BigInteger;
import org.matheclipse.core.convert.ExprVariables;
import org.matheclipse.core.convert.JASConvert;
import org.matheclipse.core.eval.interfaces.AbstractFunctionEvaluator;
import org.matheclipse.core.expression.ASTRange;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.ISymbol;

public class FactorTerms
extends AbstractFunctionEvaluator {
    @Override
    public IExpr evaluate(IAST lst) {
        if (lst.size() != 2 && lst.size() != 3) {
            return null;
        }
        ExprVariables eVar = new ExprVariables((IExpr)lst.get(1));
        if (!eVar.isSize(1)) {
            return null;
        }
        IAST variableList = eVar.getVarList();
        if (lst.size() == 3) {
            if (lst.get(2) instanceof ISymbol) {
                ISymbol variable = (ISymbol)lst.get(2);
                variableList = F.List((IExpr)variable);
            } else if (((IExpr)lst.get(2)).isList()) {
                variableList = (IAST)lst.get(2);
            } else {
                return null;
            }
        }
        if (variableList.size() != 2) {
            return null;
        }
        try {
            IExpr expr = F.evalExpandAll((IExpr)lst.get(1));
            ASTRange r = new ASTRange(variableList, 1);
            JASConvert<BigRational> jas = new JASConvert<BigRational>(r.toList(), BigRational.ZERO);
            GenPolynomial<BigRational> poly = jas.expr2Poly(expr);
            Object[] objects = jas.factorTerms(poly);
            BigInteger gcd = (BigInteger)objects[0];
            BigInteger lcm = (BigInteger)objects[1];
            if (lcm.equals(BigInteger.ZERO)) {
                return expr;
            }
            GenPolynomial iPoly = (GenPolynomial)objects[2];
            IAST result = F.Times();
            result.add(F.fraction(gcd, lcm));
            result.add(jas.integerPoly2Expr(iPoly));
            return result;
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    public void setUp(ISymbol symbol) {
        symbol.setAttributes(8);
    }
}

