/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.reflection.system;

import org.apache.commons.math.ConvergenceException;
import org.apache.commons.math.FunctionEvaluationException;
import org.apache.commons.math.analysis.solvers.BisectionSolver;
import org.apache.commons.math.analysis.solvers.BrentSolver;
import org.apache.commons.math.analysis.solvers.MullerSolver;
import org.apache.commons.math.analysis.solvers.NewtonSolver;
import org.apache.commons.math.analysis.solvers.RiddersSolver;
import org.apache.commons.math.analysis.solvers.SecantSolver;
import org.apache.commons.math.analysis.solvers.UnivariateRealSolverImpl;
import org.matheclipse.core.eval.EvalEngine;
import org.matheclipse.core.eval.interfaces.AbstractFunctionEvaluator;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.expression.IConstantHeaders;
import org.matheclipse.core.expression.Num;
import org.matheclipse.core.generic.UnaryNumerical;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.ISignedNumber;
import org.matheclipse.core.interfaces.ISymbol;

public class FindRoot
extends AbstractFunctionEvaluator
implements IConstantHeaders {
    @Override
    public IExpr evaluate(IAST ast) {
        if (ast.size() == 3 || ast.size() == 4) {
            String method = "Newton";
            if (ast.size() == 4 && ast.get(3) instanceof ISymbol) {
                method = ((IExpr)ast.get(3)).toString();
            }
            if (((IExpr)ast.get(2)).isList()) {
                IAST list = (IAST)ast.get(2);
                IExpr function = (IExpr)ast.get(1);
                if (list.size() == 4 && list.get(1) instanceof ISymbol && list.get(2) instanceof ISignedNumber && list.get(3) instanceof ISignedNumber) {
                    if (function.isAST("Equal", 3)) {
                        function = F.Plus((IExpr)((IAST)function).get(1), (IExpr)F.Times((IExpr)F.CN1, (IExpr)((IAST)function).get(2)));
                    }
                    try {
                        return F.List((IExpr)F.Rule((IExpr)list.get(1), Num.valueOf(this.findRoot(method, list, function))));
                    }
                    catch (ConvergenceException e) {
                        e.printStackTrace();
                    }
                    catch (FunctionEvaluationException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        return null;
    }

    private double findRoot(String method, IAST list, IExpr function) throws ConvergenceException, FunctionEvaluationException {
        ISymbol xVar = (ISymbol)list.get(1);
        ISignedNumber min = (ISignedNumber)list.get(2);
        ISignedNumber max = (ISignedNumber)list.get(3);
        EvalEngine engine = EvalEngine.get();
        function = F.eval(function);
        UnaryNumerical f = new UnaryNumerical(function, xVar, engine);
        UnivariateRealSolverImpl solver = new NewtonSolver();
        if (method.equals("Bisection")) {
            solver = new BisectionSolver();
        } else if (method.equals("Brent")) {
            solver = new BrentSolver();
        } else if (method.equals("Muller")) {
            solver = new MullerSolver();
        } else if (method.equals("Ridders")) {
            solver = new RiddersSolver();
        } else if (method.equals("Secant")) {
            solver = new SecantSolver();
        }
        return solver.solve(f, min.doubleValue(), max.doubleValue());
    }

    @Override
    public void setUp(ISymbol symbol) {
        symbol.setAttributes(32);
    }
}

