/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.reflection.system;

import org.apache.commons.math.analysis.polynomials.PolynomialFunction;
import org.apache.commons.math.optimization.fitting.PolynomialFitter;
import org.apache.commons.math.optimization.general.LevenbergMarquardtOptimizer;
import org.matheclipse.core.convert.Convert;
import org.matheclipse.core.eval.interfaces.AbstractFunctionEvaluator;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.IInteger;
import org.matheclipse.core.interfaces.ISignedNumber;
import org.matheclipse.core.interfaces.ISymbol;

public class Fit
extends AbstractFunctionEvaluator {
    @Override
    public IExpr evaluate(IAST ast) {
        return this.numericEval(ast);
    }

    @Override
    public IExpr numericEval(IAST ast) {
        if (ast.size() == 4 && ast.get(2) instanceof IInteger && ast.get(3) instanceof ISymbol) {
            int rowSize = -1;
            int degree = ((IInteger)ast.get(2)).toInt();
            PolynomialFitter fitter = new PolynomialFitter(degree, new LevenbergMarquardtOptimizer());
            int[] im = ((IExpr)ast.get(1)).isMatrix();
            if (im != null && im[1] == 2) {
                IAST matrix = (IAST)ast.get(1);
                int i = 1;
                while (i < matrix.size()) {
                    IAST row = matrix.getAST(i);
                    fitter.addObservedPoint(1.0, ((ISignedNumber)row.get(1)).doubleValue(), ((ISignedNumber)row.get(2)).doubleValue());
                    ++i;
                }
            } else {
                rowSize = ((IExpr)ast.get(1)).isVector();
                if (rowSize < 0) {
                    return null;
                }
                IAST vector = (IAST)ast.get(1);
                int i = 1;
                while (i < vector.size()) {
                    fitter.addObservedPoint(1.0, i, ((ISignedNumber)vector.get(i)).doubleValue());
                    ++i;
                }
            }
            PolynomialFunction fitted = fitter.fit();
            return Convert.polynomialFunction2Expr(fitted, (ISymbol)ast.get(3));
        }
        return null;
    }
}

