/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.reflection.system;

import org.matheclipse.core.eval.EvalEngine;
import org.matheclipse.core.eval.exception.IterationLimitExceeded;
import org.matheclipse.core.eval.interfaces.AbstractFunctionEvaluator;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.IInteger;
import org.matheclipse.core.interfaces.ISymbol;
import org.matheclipse.parser.client.SyntaxError;

public class FixedPoint
extends AbstractFunctionEvaluator {
    @Override
    public IExpr evaluate(IAST ast) {
        block10: {
            try {
                IExpr last;
                if (ast.size() != 3 && ast.size() != 4) break block10;
                EvalEngine engine = EvalEngine.get();
                int iterationLimit = engine.getIterationLimit();
                int iterationCounter = 1;
                IExpr f = (IExpr)ast.get(1);
                IExpr current = (IExpr)ast.get(2);
                int steps = Integer.MAX_VALUE;
                if (ast.size() == 4) {
                    if (!(ast.get(3) instanceof IInteger)) {
                        return null;
                    }
                    try {
                        steps = ((IInteger)ast.get(3)).toInt();
                    }
                    catch (ArithmeticException e) {
                        EvalEngine.get().setNumericMode(false);
                        return null;
                    }
                }
                do {
                    last = current;
                    current = engine.evaluate(F.Apply(f, current));
                    if (iterationLimit < 0 || iterationLimit > ++iterationCounter) continue;
                    IterationLimitExceeded.throwIt(iterationCounter, ast);
                } while (!current.isSame(last) && --steps > 0);
                IExpr iExpr = current;
                return iExpr;
            }
            finally {
                EvalEngine.get().setNumericMode(false);
            }
        }
        return null;
    }

    @Override
    public void setUp(ISymbol symbol) throws SyntaxError {
        symbol.setAttributes(96);
    }
}

