/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.reflection.system;

import org.matheclipse.core.eval.exception.WrongNumberOfArguments;
import org.matheclipse.core.eval.interfaces.IFunctionEvaluator;
import org.matheclipse.core.eval.interfaces.INumeric;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.ISignedNumber;
import org.matheclipse.core.interfaces.ISymbol;

public class Floor
implements IFunctionEvaluator,
INumeric {
    @Override
    public IExpr evaluate(IAST functionList) {
        if (functionList.size() != 2) {
            throw new WrongNumberOfArguments(functionList, 1, functionList.size() - 1);
        }
        if (functionList.get(1) instanceof ISignedNumber) {
            return ((ISignedNumber)functionList.get(1)).floor();
        }
        return null;
    }

    @Override
    public IExpr numericEval(IAST functionList) {
        return this.evaluate(functionList);
    }

    @Override
    public void setUp(ISymbol symbol) {
        symbol.setAttributes(1152);
    }

    @Override
    public double evalReal(double[] stack, int top, int size) {
        if (size != 1) {
            throw new UnsupportedOperationException();
        }
        return Math.floor(stack[top]);
    }
}

