/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.reflection.system;

import java.io.UnsupportedEncodingException;
import java.util.List;
import org.matheclipse.core.eval.exception.Validate;
import org.matheclipse.core.eval.interfaces.AbstractFunctionEvaluator;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.expression.StringX;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.IInteger;
import org.matheclipse.core.interfaces.ISymbol;

public class FromCharacterCode
extends AbstractFunctionEvaluator {
    @Override
    public IExpr evaluate(IAST ast) {
        if (ast.size() != 2) {
            return null;
        }
        if (((IExpr)ast.get(1)).isList()) {
            IAST list = (IAST)ast.get(1);
            StringBuffer buffer = new StringBuffer();
            int i = 1;
            while (i < list.size()) {
                if (!(list.get(i) instanceof IInteger)) {
                    return null;
                }
                char ch = (char)Validate.checkIntType(list, i);
                buffer.append(ch);
                ++i;
            }
            return StringX.valueOf(buffer);
        }
        if (ast.get(1) instanceof IInteger) {
            char ch = (char)Validate.checkIntType(ast, 1);
            return StringX.valueOf(ch);
        }
        return null;
    }

    @Override
    public void setUp(ISymbol symbol) {
    }

    public static List<IExpr> fromCharcterCode(String unicodeInput, String inputEncoding, List<IExpr> list) {
        try {
            String utf8String = new String(unicodeInput.getBytes(inputEncoding), "UTF-8");
            int i = 0;
            while (i < utf8String.length()) {
                char characterCode = utf8String.charAt(i);
                list.add(F.integer(characterCode));
                ++i;
            }
            return list;
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return null;
        }
    }
}

