/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.reflection.system;

import edu.jas.arith.BigRational;
import edu.jas.gb.GroebnerBasePartial;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.OptimizedPolynomialList;
import java.util.ArrayList;
import org.matheclipse.core.convert.JASConvert;
import org.matheclipse.core.eval.interfaces.AbstractFunctionEvaluator;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.ISymbol;

public class GroebnerBasis
extends AbstractFunctionEvaluator {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public IExpr evaluate(IAST lst) {
        if (lst.size() < 3) return null;
        try {
            if (((IExpr)lst.get(1)).isVector() < 0) {
                return null;
            }
            if (((IExpr)lst.get(2)).isVector() < 0) {
                return null;
            }
            if (lst.size() != 3) return null;
            IAST vars = (IAST)lst.get(2);
            if (vars.size() <= 1) {
                return null;
            }
            ArrayList<ISymbol> varList = new ArrayList<ISymbol>(vars.size() - 1);
            String[] pvars = new String[vars.size() - 1];
            int i = 1;
            while (i < vars.size()) {
                if (!(vars.get(i) instanceof ISymbol)) {
                    return null;
                }
                varList.add((ISymbol)vars.get(i));
                pvars[i - 1] = ((ISymbol)vars.get(i)).toString();
                ++i;
            }
            GroebnerBasePartial gbp = new GroebnerBasePartial();
            IAST polys = (IAST)lst.get(1);
            ArrayList polyList = new ArrayList(polys.size() - 1);
            JASConvert<BigRational> jas = new JASConvert<BigRational>(varList, BigRational.ZERO);
            int i2 = 1;
            while (i2 < polys.size()) {
                IExpr expr = F.evalExpandAll((IExpr)polys.get(i2));
                GenPolynomial<BigRational> poly = jas.expr2Poly(expr);
                polyList.add(poly);
                ++i2;
            }
            OptimizedPolynomialList opl = gbp.partialGB(polyList, pvars);
            IAST resultList = F.List();
            for (GenPolynomial p : opl.list) {
                resultList.add(jas.poly2Expr(p, null));
            }
            return resultList;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }
}

