/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.reflection.system;

import apache.harmony.math.BigInteger;
import apache.harmony.math.Rational;
import org.matheclipse.core.eval.exception.Validate;
import org.matheclipse.core.eval.exception.WrongNumberOfArguments;
import org.matheclipse.core.eval.interfaces.IFunctionEvaluator;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.IInteger;
import org.matheclipse.core.interfaces.ISymbol;

public class HarmonicNumber
implements IFunctionEvaluator {
    @Override
    public IExpr evaluate(IAST ast) {
        if (ast.size() != 2) {
            throw new WrongNumberOfArguments(ast, 1, ast.size() - 1);
        }
        IExpr arg1 = (IExpr)ast.get(1);
        if (arg1 instanceof IInteger) {
            int n = Validate.checkIntType(ast, 1, Integer.MIN_VALUE);
            if (n < 0) {
                return null;
            }
            if (n == 0) {
                return F.C0;
            }
            if (n == 1) {
                return F.C1;
            }
            --n;
            Rational sum = Rational.ONE;
            BigInteger counter = BigInteger.ONE;
            int i = 0;
            while (i < n) {
                counter = counter.add(BigInteger.ONE);
                sum = sum.plus(Rational.valueOf(BigInteger.ONE, counter));
                ++i;
            }
            return F.fraction(sum);
        }
        return null;
    }

    @Override
    public IExpr numericEval(IAST functionList) {
        return this.evaluate(functionList);
    }

    @Override
    public void setUp(ISymbol symbol) {
    }
}

