/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.reflection.system;

import org.matheclipse.core.eval.exception.Validate;
import org.matheclipse.core.eval.interfaces.AbstractFunctionEvaluator;
import org.matheclipse.core.expression.AST;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.IInteger;
import org.matheclipse.generic.interfaces.IIndexFunction;
import org.matheclipse.generic.nested.IndexTableGenerator;

public class HilbertMatrix
extends AbstractFunctionEvaluator {
    @Override
    public IExpr evaluate(IAST functionList) {
        int rowSize = 0;
        int columnSize = 0;
        if (functionList.size() == 2 && functionList.get(1) instanceof IInteger) {
            columnSize = rowSize = Validate.checkIntType(functionList, 1);
        } else if (functionList.size() == 3 && functionList.get(1) instanceof IInteger && functionList.get(2) instanceof IInteger) {
            rowSize = Validate.checkIntType(functionList, 1);
            columnSize = Validate.checkIntType(functionList, 2);
        } else {
            return null;
        }
        IAST resultList = F.List();
        int[] indexArray = new int[]{rowSize, columnSize};
        IndexTableGenerator<IExpr, IAST> generator = new IndexTableGenerator<IExpr, IAST>(indexArray, resultList, new HilbertFunctionDiagonal(), AST.COPY);
        IAST matrix = (IAST)generator.table();
        if (matrix != null) {
            matrix.addEvalFlags(32);
        }
        return matrix;
    }

    public class HilbertFunctionDiagonal
    implements IIndexFunction<IExpr> {
        @Override
        public IExpr evaluate(int[] index) {
            int res = index[0] + index[1] + 1;
            return F.Power((IExpr)F.integer(res), F.CN1);
        }
    }
}

