/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.reflection.system;

import org.matheclipse.core.convert.ExprVariables;
import org.matheclipse.core.eval.EvalEngine;
import org.matheclipse.core.eval.interfaces.AbstractFunctionEvaluator;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.ISymbol;
import org.matheclipse.core.polynomials.HornerScheme;

public class Horner
extends AbstractFunctionEvaluator {
    @Override
    public IExpr evaluate(IAST ast) {
        if (ast.size() != 2) {
            return null;
        }
        IExpr expr = (IExpr)ast.get(1);
        if (!(expr instanceof IAST)) {
            return expr;
        }
        IAST poly = (IAST)expr;
        ExprVariables eVar = new ExprVariables((IExpr)ast.get(1));
        IAST variables = eVar.getVarList();
        if (variables.size() >= 2) {
            ISymbol sym = (ISymbol)variables.get(1);
            if (poly.isASTSizeGE(F.Plus, 2)) {
                HornerScheme scheme = new HornerScheme();
                return scheme.generate(EvalEngine.get().isNumericMode(), poly, sym);
            }
        }
        return expr;
    }

    @Override
    public void setUp(ISymbol symbol) {
    }
}

