/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.reflection.system;

import org.matheclipse.core.eval.exception.Validate;
import org.matheclipse.core.eval.interfaces.AbstractFunctionEvaluator;
import org.matheclipse.core.expression.AST;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.generic.UnaryIndexFunctionDiagonal;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.IInteger;
import org.matheclipse.generic.nested.IndexTableGenerator;

public class IdentityMatrix
extends AbstractFunctionEvaluator {
    @Override
    public IExpr evaluate(IAST functionList) {
        if (functionList.size() != 2) {
            return null;
        }
        if (functionList.get(1) instanceof IInteger) {
            int indx = Validate.checkIntType(functionList, 1);
            IExpr[] valueArray = new IExpr[]{F.C0, F.C1};
            return IdentityMatrix.diagonalMatrix(valueArray, indx);
        }
        return null;
    }

    public static IAST diagonalMatrix(IExpr[] valueArray, int dimension) {
        IAST resultList = F.List();
        int[] indexArray = new int[]{dimension, dimension};
        IndexTableGenerator<IExpr, IAST> generator = new IndexTableGenerator<IExpr, IAST>(indexArray, resultList, new UnaryIndexFunctionDiagonal(valueArray), AST.COPY);
        IAST matrix = (IAST)generator.table();
        if (matrix != null) {
            matrix.addEvalFlags(32);
        }
        return matrix;
    }
}

