/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.reflection.system;

import edu.jas.arith.BigRational;
import edu.jas.poly.ExpVector;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.Monomial;
import edu.jas.ufd.FactorAbstract;
import edu.jas.ufd.FactorFactory;
import edu.jas.ufd.SquarefreeAbstract;
import edu.jas.ufd.SquarefreeFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.SortedMap;
import org.matheclipse.core.convert.JASConvert;
import org.matheclipse.core.eval.EvalEngine;
import org.matheclipse.core.eval.exception.RecursionLimitExceeded;
import org.matheclipse.core.eval.interfaces.AbstractFunctionEvaluator;
import org.matheclipse.core.expression.ASTRange;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.expression.IConstantHeaders;
import org.matheclipse.core.generic.Functors;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.IFraction;
import org.matheclipse.core.interfaces.IInteger;
import org.matheclipse.core.interfaces.INumber;
import org.matheclipse.core.interfaces.ISymbol;
import org.matheclipse.core.reflection.system.Apart;
import org.matheclipse.core.reflection.system.PolynomialQ;

public class Integrate
extends AbstractFunctionEvaluator
implements IConstantHeaders {
    private static String[] RULES = new String[]{"Integrate[y_ * x_,z_Symbol]:= y*Integrate[x,z] /; FreeQ[y,z]", "Integrate[y_,x_Symbol]:=y*x /; FreeQ[y,x]", "Integrate[x_,x_Symbol]:= x^2/2", "Integrate[x_^n_NumberQ, x_Symbol]:=x^(n+1)/(n+1) /; n!=(-1)", "Integrate[(a_+x_)^(-1), x_Symbol]:=Log[x+a] /; FreeQ[a,x]", "Integrate[(a_.*x_+b_)^n_NumberQ,x_Symbol]:= (a*x+b)^(n+1)/(a*(n+1)) /; (n!=(-1))&&FreeQ[{a,b},x]", "Integrate[E_^(a_.*x_), x_Symbol]:=a^(-1)*E^(a*x) /; FreeQ[a,x]", "Integrate[x_ * E_^(a_.*x_), x_Symbol]:=a^(-2)*E^(a*x)*(a*x-1) /; FreeQ[a,x]", "Integrate[x_^n_IntegerQ * E_^(a_.*x_), x_Symbol]:=a^(-1)*x^n*E^(a*x)-n/a*Integrate[x^(n-1)*E^(a*x),x] /; Positive[n]&&FreeQ[a,x]", "Integrate[Log[a_.*x_], x_Symbol]:=Log[a*x]*x-x /; FreeQ[a,x]", "Integrate[Sinh[x_], x_Symbol]:=Cosh[x]", "Integrate[Cosh[x_], x_Symbol]:=Sinh[x]", "Integrate[ArcSinh[x_], x_Symbol]:=x*ArcSinh[x]-Sqrt[x^2+1]", "Integrate[ArcCosh[x_], x_Symbol]:=x*ArcCosh[x]-Sqrt[x^2-1]", "Integrate[ArcTanh[x_], x_Symbol]:=x*ArcTanh[x]+1/2*Log[1-x^2]", "Integrate[Sin[a_.*x_]^n_IntegerQ, x_Symbol]:= -Sin[a*x]^(n-1)*Cos[a*x]/(n*a)+(n-1)/n*Integrate[Sin[a*x]^(n-2),x]/;Positive[n]&&FreeQ[a,x]", "Integrate[Sin[a_.+b_.*x_],x_Symbol] := -Cos[a+b*x]/b /; FreeQ[{a,b},x]", "Integrate[Cos[x_], x_Symbol]:= Sin[x]", "Integrate[Cos[a_*x_], x_Symbol]:= Sin[a*x]/a /; FreeQ[a,x]", "Integrate[Cos[a_.*x_]^n_IntegerQ, x_Symbol]:= Cos[a*x]^(n-1)*Sin[a*x]/(n*a)+(n-1)/n*Integrate[Cos[a*x]^(n-2),x] /; Positive[n]&&FreeQ[a,x]", "Integrate[Tan[x_], x_Symbol]:= -Log[Cos[x]]", "Integrate[Tan[a_*x_], x_Symbol]:= -Log[Cos[a*x]]/a /; FreeQ[a,x]", "Integrate[Tan[x_]^n_IntegerQ, x_Symbol]:= 1/(n-1)*Tan[x]^(n-1)-Integrate[Tan[x]^(n-2),x] /; Positive[n]", "Integrate[Tan[a_*x_]^n_IntegerQ, x_Symbol]:= 1/(a*(n-1))*Tan[a*x]^(n-1)-Integrate[Tan[a*x]^(n-2),x] /; Positive[n]&&FreeQ[a,x]", "Integrate[ArcSin[x_], x_Symbol]:=x*ArcSin[x]+Sqrt[1-x^2]", "Integrate[ArcSin[a_*x_], x_Symbol]:= x*ArcSin[a*x]+Sqrt[1-a^2*x^2]/a /; FreeQ[a,x]", "Integrate[ArcCos[x_], x_Symbol]:= x*ArcCos[x]-Sqrt[1-x^2]", "Integrate[ArcCos[a_*x_], x_Symbol]:= x*ArcCos[a*x]-Sqrt[1-a^2*x^2]/a  /; FreeQ[a,x]", "Integrate[ArcTan[x_], x_Symbol]:= x*ArcTan[x]-1/2*Log[1+x^2]", "Integrate[ArcTan[a_*x_], x_Symbol]:= x*ArcTan[a*x]-1/2*Log[1+a^2*x^2]/a  /; FreeQ[a,x]"};

    @Override
    public IExpr evaluate(IAST ast) {
        if (ast.size() != 3) {
            return null;
        }
        if (ast.get(1) instanceof INumber) {
            return F.Times((IExpr)ast.get(1), (IExpr)ast.get(2));
        }
        if (((IExpr)ast.get(1)).equals(ast.get(2))) {
            return F.Times((IExpr)F.C1D2, (IExpr)F.Power((IExpr)ast.get(1), F.C2));
        }
        if (ast.get(1) instanceof IAST) {
            IExpr arg = F.evalExpandAll((IExpr)ast.get(1));
            if (!((IExpr)ast.get(1)).equals(arg)) {
                IAST clon = ast.clone();
                clon.set(1, arg);
                return clon;
            }
            IAST arg1 = (IAST)ast.get(1);
            IExpr header = arg1.head();
            if (arg1.size() >= 3) {
                if (header == F.Plus) {
                    return arg1.map(Functors.replace1st(F.Integrate(F.Null, (IExpr)ast.get(2))));
                }
                if ((header == F.Times || header == F.Power) && !arg1.isEvalFlagOn(128) && ast.get(2) instanceof ISymbol) {
                    ISymbol symbol = (ISymbol)ast.get(2);
                    IExpr[] parts = Apart.getFractionalParts(arg1);
                    if (parts != null) {
                        IExpr result;
                        IAST apartPlus = Integrate.integrateByPartialFractions(parts, symbol);
                        if (apartPlus != null && apartPlus.size() > 1) {
                            if (apartPlus.size() == 2) {
                                return (IExpr)apartPlus.get(1);
                            }
                            return apartPlus;
                        }
                        if (arg1.isTimes() && (result = Integrate.integratePolynomialByParts(arg1, symbol)) != null) {
                            return result;
                        }
                    }
                }
            }
        }
        return null;
    }

    public static boolean isQuadratic(GenPolynomial<BigRational> poly, BigRational[] result) {
        if (poly.degree() <= 2L && poly.numberOfVariables() == 1) {
            result[0] = BigRational.ZERO;
            result[1] = BigRational.ZERO;
            result[2] = BigRational.ZERO;
            for (Monomial<BigRational> monomial : poly) {
                BigRational coeff = monomial.coefficient();
                ExpVector exp = monomial.exponent();
                int i = 0;
                while (i < exp.length()) {
                    result[(int)exp.getVal((int)i)] = coeff;
                    ++i;
                }
            }
            return true;
        }
        return false;
    }

    private static IAST integrateByPartialFractions(IExpr[] parts, ISymbol x) {
        try {
            IAST variableList = F.List((IExpr)x);
            IExpr exprNumerator = F.evalExpandAll(parts[0]);
            IExpr exprDenominator = F.evalExpandAll(parts[1]);
            ASTRange r = new ASTRange(variableList, 1);
            List<IExpr> varList = r.toList();
            String[] varListStr = new String[]{((IExpr)variableList.get(1)).toString()};
            JASConvert<BigRational> jas = new JASConvert<BigRational>(varList, BigRational.ZERO);
            GenPolynomial<BigRational> numerator = jas.expr2Poly(exprNumerator);
            GenPolynomial<BigRational> denominator = jas.expr2Poly(exprDenominator);
            FactorAbstract<BigRational> factorAbstract = FactorFactory.getImplementation(BigRational.ZERO);
            SortedMap sfactors = factorAbstract.baseFactors(denominator);
            ArrayList<GenPolynomial<BigRational>> D2 = new ArrayList<GenPolynomial<BigRational>>(sfactors.keySet());
            SquarefreeAbstract<BigRational> sqf = SquarefreeFactory.getImplementation(BigRational.ZERO);
            List<List<GenPolynomial<BigRational>>> Ai = sqf.basePartialFraction(numerator, sfactors);
            if (Ai.size() > 0) {
                IExpr temp;
                BigRational[] numer = new BigRational[3];
                BigRational[] denom = new BigRational[3];
                IAST result = F.Plus();
                if (!Ai.get(0).get(0).isZERO()) {
                    temp = F.eval(jas.poly2Expr(Ai.get(0).get(0)));
                    if (temp instanceof IAST) {
                        ((IAST)temp).addEvalFlags(128);
                    }
                    result.add(F.Integrate(temp, x));
                }
                int i = 1;
                while (i < Ai.size()) {
                    List<GenPolynomial<BigRational>> list = Ai.get(i);
                    long j = 0L;
                    for (GenPolynomial<BigRational> genPolynomial : list) {
                        if (!genPolynomial.isZERO()) {
                            IFraction a;
                            IFraction B;
                            IFraction A;
                            boolean isDegreeLE2;
                            boolean bl = isDegreeLE2 = ((GenPolynomial)D2.get(i - 1)).degree() <= 2L;
                            if (isDegreeLE2 && j == 1L) {
                                if (genPolynomial.isONE()) {
                                    Integrate.isQuadratic((GenPolynomial)D2.get(i - 1), denom);
                                    IFraction a2 = F.fraction(denom[2].numerator(), denom[2].denominator());
                                    IFraction b = F.fraction(denom[1].numerator(), denom[1].denominator());
                                    IFraction c = F.fraction(denom[0].numerator(), denom[0].denominator());
                                    if (a2.isZero()) {
                                        result.add(F.Times((IExpr)F.Log(F.Plus((IExpr)c, (IExpr)F.Times((IExpr)b, (IExpr)x))), (IExpr)F.Power((IExpr)b, F.CN1)));
                                    } else {
                                        BigRational cmp = denom[1].multiply(denom[1]).subtract(BigRational.valueOf(4L).multiply(denom[2]).multiply(denom[0]));
                                        int cmpTo = cmp.compareTo(BigRational.ZERO);
                                        IAST ax2Plusb = F.Plus((IExpr)F.Times(F.C2, a2, x), (IExpr)b);
                                        if (cmpTo == 0) {
                                            result.add(F.Times((IExpr)F.integer(-2L), (IExpr)F.Power((IExpr)ax2Plusb, F.CN1)));
                                        } else if (cmpTo > 0) {
                                            temp = F.eval(F.Power((IExpr)F.Subtract(F.Sqr(b), F.Times(F.C4, a2, c)), F.C1D2));
                                            result.add(F.Times((IExpr)F.Power(temp, F.CN1), (IExpr)F.Log(F.Times((IExpr)F.Subtract(ax2Plusb, temp), (IExpr)F.Power((IExpr)F.Plus((IExpr)ax2Plusb, temp), F.CN1)))));
                                        } else {
                                            temp = F.eval(F.Power((IExpr)F.Subtract(F.Times(F.C4, a2, c), F.Sqr(b)), F.CN1D2));
                                            result.add(F.Times(F.C2, temp, F.ArcTan(F.Times((IExpr)ax2Plusb, temp))));
                                        }
                                    }
                                } else {
                                    Integrate.isQuadratic(genPolynomial, numer);
                                    A = F.fraction(numer[1].numerator(), numer[1].denominator());
                                    B = F.fraction(numer[0].numerator(), numer[0].denominator());
                                    Integrate.isQuadratic((GenPolynomial)D2.get(i - 1), denom);
                                    a = F.fraction(denom[2].numerator(), denom[2].denominator());
                                    IFraction p = F.fraction(denom[1].numerator(), denom[1].denominator());
                                    IFraction q = F.fraction(denom[0].numerator(), denom[0].denominator());
                                    temp = A.isZero() ? F.Times(B, F.Log(F.Plus((IExpr)q, (IExpr)F.Times((IExpr)p, (IExpr)x))), F.Power((IExpr)p, F.CN1)) : F.Plus((IExpr)F.Times(F.C1D2, A, F.Log(F.Plus(q, F.Times((IExpr)p, (IExpr)x), F.Power((IExpr)x, F.C2)))), (IExpr)F.Times(F.ArcTan(F.Times((IExpr)F.Plus((IExpr)p, (IExpr)F.Times((IExpr)F.C2, (IExpr)x)), (IExpr)F.Power((IExpr)F.Plus((IExpr)F.Times((IExpr)F.CN1, (IExpr)F.Power((IExpr)p, F.C2)), (IExpr)F.Times((IExpr)F.C4, (IExpr)q)), F.CN1D2))), F.Plus((IExpr)F.Times((IExpr)F.C2, (IExpr)B), (IExpr)F.Times(F.CN1, A, p)), F.Power((IExpr)F.Plus((IExpr)F.Times((IExpr)F.CN1, (IExpr)F.Power((IExpr)p, F.C2)), (IExpr)F.Times((IExpr)F.C4, (IExpr)q)), F.CN1D2)));
                                    result.add(F.eval(temp));
                                }
                            } else if (isDegreeLE2 && j > 1L) {
                                Integrate.isQuadratic(genPolynomial, numer);
                                A = F.fraction(numer[1].numerator(), numer[1].denominator());
                                B = F.fraction(numer[0].numerator(), numer[0].denominator());
                                Integrate.isQuadratic((GenPolynomial)D2.get(i - 1), denom);
                                a = F.fraction(denom[2].numerator(), denom[2].denominator());
                                IFraction b = F.fraction(denom[1].numerator(), denom[1].denominator());
                                IFraction c = F.fraction(denom[0].numerator(), denom[0].denominator());
                                IInteger k = F.integer(j);
                                temp = A.isZero() ? F.Times((IExpr)B, (IExpr)F.Plus((IExpr)F.Times(F.Integrate(F.Power((IExpr)F.Plus(c, F.Times((IExpr)b, (IExpr)x), F.Times((IExpr)a, (IExpr)F.Power((IExpr)x, F.C2))), F.Plus((IExpr)F.C1, (IExpr)F.Times((IExpr)F.CN1, (IExpr)k))), x), F.Plus((IExpr)F.Times((IExpr)F.integer(-6L), (IExpr)a), (IExpr)F.Times(F.C4, a, k)), F.Power((IExpr)F.Plus((IExpr)F.CN1, (IExpr)k), F.CN1), F.Power((IExpr)F.Plus((IExpr)F.Times((IExpr)F.CN1, (IExpr)F.Power((IExpr)b, F.C2)), (IExpr)F.Times(F.C4, a, c)), F.CN1)), (IExpr)F.Times(F.Plus((IExpr)b, (IExpr)F.Times(F.C2, a, x)), F.Power((IExpr)F.Plus((IExpr)F.CN1, (IExpr)k), F.CN1), F.Power((IExpr)F.Plus((IExpr)F.Times((IExpr)F.CN1, (IExpr)F.Power((IExpr)b, F.C2)), (IExpr)F.Times(F.C4, a, c)), F.CN1), F.Power((IExpr)F.Plus(c, F.Times((IExpr)b, (IExpr)x), F.Times((IExpr)a, (IExpr)F.Power((IExpr)x, F.C2))), F.Times((IExpr)F.CN1, (IExpr)F.Plus((IExpr)F.CN1, (IExpr)k)))))) : F.Plus((IExpr)F.Times((IExpr)F.Integrate(F.Power((IExpr)F.Plus(c, F.Times((IExpr)b, (IExpr)x), F.Times((IExpr)a, (IExpr)F.Power((IExpr)x, F.C2))), F.Times((IExpr)F.CN1, (IExpr)k)), x), (IExpr)F.Plus((IExpr)B, (IExpr)F.Times(F.CN1D2, A, F.Power((IExpr)a, F.CN1), b))), (IExpr)F.Times(F.CN1D2, A, F.Power((IExpr)a, F.CN1), F.Power((IExpr)F.Plus((IExpr)F.CN1, (IExpr)k), F.CN1), F.Power((IExpr)F.Plus(c, F.Times((IExpr)b, (IExpr)x), F.Times((IExpr)a, (IExpr)F.Power((IExpr)x, F.C2))), F.Times((IExpr)F.CN1, (IExpr)F.Plus((IExpr)F.CN1, (IExpr)k)))));
                                result.add(F.eval(temp));
                            } else {
                                temp = F.eval(F.Times((IExpr)jas.poly2Expr(genPolynomial), (IExpr)F.Power((IExpr)jas.poly2Expr((GenPolynomial)D2.get(i - 1)), F.integer(j * -1L))));
                                if (!temp.equals(F.C0)) {
                                    if (temp instanceof IAST) {
                                        ((IAST)temp).addEvalFlags(128);
                                    }
                                    result.add(F.Integrate(temp, x));
                                }
                            }
                        }
                        ++j;
                    }
                    ++i;
                }
                return result;
            }
        }
        catch (ClassCastException variableList) {
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    private static IExpr integratePolynomialByParts(IAST arg1, ISymbol symbol) {
        IAST fTimes = F.Times();
        IAST gTimes = F.Times();
        Integrate.collectPolynomialTerms(arg1, symbol, fTimes, gTimes);
        IExpr f = fTimes;
        IExpr g = gTimes;
        if (fTimes.size() == 1) {
            return null;
        }
        if (fTimes.size() == 2) {
            f = (IExpr)fTimes.get(1);
        }
        if (gTimes.size() == 1) {
            return null;
        }
        if (gTimes.size() == 2) {
            g = (IExpr)gTimes.get(1);
        }
        return Integrate.integrateByParts(f, g, symbol);
    }

    private static IExpr integrateByParts(IExpr f, IExpr g, ISymbol symbol) {
        EvalEngine engine = EvalEngine.get();
        int limit = engine.getRecursionLimit();
        try {
            IExpr fIntegrated;
            if (limit <= 0) {
                engine.setRecursionLimit(128);
            }
            if (!(fIntegrated = F.eval(F.Integrate(f, symbol))).isFree(F.Integrate)) {
                return null;
            }
            IExpr gDerived = F.eval(F.D(g, symbol));
            IExpr iExpr = F.eval(F.Plus((IExpr)F.Times(fIntegrated, g), (IExpr)F.Times((IExpr)F.CN1, (IExpr)F.Integrate(F.Times(fIntegrated, gDerived), symbol))));
            return iExpr;
        }
        catch (RecursionLimitExceeded rle) {
            engine.setRecursionLimit(limit);
        }
        finally {
            engine.setRecursionLimit(limit);
        }
        return null;
    }

    private static void collectPolynomialTerms(IAST timesAST, ISymbol symbol, IAST fTimes, IAST gTimes) {
        int i = 1;
        while (i < timesAST.size()) {
            IExpr temp = (IExpr)timesAST.get(i);
            if (temp.isFree(symbol)) {
                fTimes.add(temp);
            } else if (temp.equals(symbol)) {
                fTimes.add(temp);
            } else if (PolynomialQ.polynomialQ(temp, F.List((IExpr)symbol))) {
                fTimes.add(temp);
            } else {
                gTimes.add(temp);
            }
            ++i;
        }
    }

    @Override
    public String[] getRules() {
        return RULES;
    }
}

