/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.reflection.system;

import org.matheclipse.core.eval.interfaces.AbstractFunctionEvaluator;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.IInteger;
import org.matheclipse.core.interfaces.ISymbol;
import org.matheclipse.generic.combinatoric.KPartitionsIterable;
import org.matheclipse.generic.combinatoric.KPermutationsIterable;

public class KOrderlessPartitions
extends AbstractFunctionEvaluator {
    @Override
    public IExpr evaluate(IAST functionList) {
        if (functionList.size() == 3 && functionList.get(1) instanceof IAST && functionList.get(2) instanceof IInteger) {
            IAST listArg0 = (IAST)functionList.get(1);
            ISymbol sym = listArg0.topHead();
            int n = listArg0.size() - 1;
            int k = ((IInteger)functionList.get(2)).getBigNumerator().intValue();
            IAST result = F.function(F.List);
            KPermutationsIterable permutationIterator = new KPermutationsIterable(listArg0, n, 1);
            KPartitionsIterable partitionIterator = new KPartitionsIterable(n, k);
            for (int[] permutationsIndex : permutationIterator) {
                for (int[] partitionsIndex : partitionIterator) {
                    IAST partition = this.createSinglePartition(listArg0, sym, permutationsIndex, partitionsIndex);
                    if (partition == null) continue;
                    result.add(partition);
                }
                partitionIterator.reset();
            }
            return result;
        }
        return null;
    }

    private IAST createSinglePartition(IAST listArg0, ISymbol sym, int[] permutationsIndex, int[] partitionsIndex) {
        IAST partitionElement;
        IAST partition = F.function(F.List);
        int n = listArg0.size() - 1;
        int partitionStartIndex = 0;
        int i = 1;
        while (i < partitionsIndex.length) {
            partitionElement = F.function(sym);
            if (partitionStartIndex + 1 == partitionsIndex[i]) {
                if ((sym.getAttributes() & 1) == 1) {
                    partition.add((IExpr)listArg0.get(permutationsIndex[partitionStartIndex] + 1));
                } else {
                    partitionElement.add((IExpr)listArg0.get(permutationsIndex[partitionStartIndex] + 1));
                    partition.add(partitionElement);
                }
            } else {
                int m = partitionStartIndex;
                while (m < partitionsIndex[i]) {
                    if (m + 1 < partitionsIndex[i] && ((IExpr)listArg0.get(permutationsIndex[m + 1] + 1)).isLTOrdered((IExpr)listArg0.get(permutationsIndex[m] + 1))) {
                        return null;
                    }
                    partitionElement.add((IExpr)listArg0.get(permutationsIndex[m] + 1));
                    ++m;
                }
                partition.add(partitionElement);
            }
            partitionStartIndex = partitionsIndex[i];
            ++i;
        }
        partitionElement = F.function(sym);
        if (partitionStartIndex + 1 == n) {
            if ((sym.getAttributes() & 1) == 1) {
                partition.add((IExpr)listArg0.get(permutationsIndex[partitionStartIndex] + 1));
            } else {
                partitionElement.add((IExpr)listArg0.get(permutationsIndex[partitionStartIndex] + 1));
                partition.add(partitionElement);
            }
        } else {
            int m = partitionStartIndex;
            while (m < n) {
                if (m + 1 < n && ((IExpr)listArg0.get(permutationsIndex[m + 1] + 1)).isLTOrdered((IExpr)listArg0.get(permutationsIndex[m] + 1))) {
                    return null;
                }
                partitionElement.add((IExpr)listArg0.get(permutationsIndex[m] + 1));
                ++m;
            }
            partition.add(partitionElement);
        }
        return partition;
    }
}

